/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.runner.scheduler;

import dagger.Module;
import dagger.Provides;
import dagger.multibindings.ElementsIntoSet;
import io.deephaven.base.clock.Clock;
import io.deephaven.chunk.util.pools.MultiChunkPool;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.server.runner.DeephavenApiServer;
import io.deephaven.server.util.Scheduler;
import io.deephaven.util.process.ProcessEnvironment;
import io.deephaven.util.thread.NamingThreadFactory;
import io.deephaven.util.thread.ThreadInitializationFactory;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Module
public class SchedulerModule {
    @Provides
    @ElementsIntoSet
    static Set<ThreadInitializationFactory> primeThreadInitializers() {
        return Collections.emptySet();
    }

    @Provides
    static ThreadInitializationFactory provideThreadInitializationFactory(Set<ThreadInitializationFactory> factories) {
        return ThreadInitializationFactory.of(factories);
    }

    @Provides
    @Singleton
    public static Scheduler provideScheduler(@Named(value="DEFAULT") UpdateGraph updateGraph, @Named(value="scheduler.poolSize") int poolSize, ThreadInitializationFactory initializationFactory) {
        ThreadFactory concurrentThreadFactory = new ThreadFactory("Scheduler-Concurrent", updateGraph, initializationFactory);
        ScheduledThreadPoolExecutor concurrentExecutor = new ScheduledThreadPoolExecutor(poolSize, (java.util.concurrent.ThreadFactory)((Object)concurrentThreadFactory)){

            @Override
            protected void afterExecute(Runnable task, Throwable error) {
                super.afterExecute(task, error);
                SchedulerModule.afterExecute("concurrentExecutor", task, error);
            }
        };
        ThreadFactory serialThreadFactory = new ThreadFactory("Scheduler-Serial", updateGraph, initializationFactory);
        ThreadPoolExecutor serialExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(), (java.util.concurrent.ThreadFactory)((Object)serialThreadFactory)){

            @Override
            protected void afterExecute(Runnable task, Throwable error) {
                super.afterExecute(task, error);
                SchedulerModule.afterExecute("serialExecutor", task, error);
            }
        };
        return new Scheduler.DelegatingImpl(serialExecutor, concurrentExecutor, (Clock)Clock.system());
    }

    private static void afterExecute(String executorType, Runnable task, Throwable error) {
        if (error != null) {
            SchedulerModule.report(executorType, error);
        } else if (task instanceof Future) {
            try {
                ((Future)((Object)task)).get();
            }
            catch (InterruptedException ignored) {
                Thread.interrupted();
            }
            catch (CancellationException ignored) {
            }
            catch (ExecutionException e) {
                SchedulerModule.report(executorType, e.getCause());
            }
        }
    }

    private static void report(String executorType, Throwable error) {
        ProcessEnvironment.getGlobalFatalErrorReporter().report("Exception while processing " + executorType + " task", error);
    }

    private static class ThreadFactory
    extends NamingThreadFactory {
        private final UpdateGraph updateGraph;
        private final ThreadInitializationFactory initializationFactory;

        public ThreadFactory(String name, UpdateGraph updateGraph, ThreadInitializationFactory initializationFactory) {
            super(DeephavenApiServer.class, name);
            this.updateGraph = updateGraph;
            this.initializationFactory = initializationFactory;
        }

        public Thread newThread(@NotNull Runnable r) {
            return super.newThread(this.initializationFactory.createInitializer(() -> {
                MultiChunkPool.enableDedicatedPoolForThisThread();
                ExecutionContext.getContext().withUpdateGraph(this.updateGraph).open();
                r.run();
            }));
        }
    }
}

