/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.runner;

import dagger.Module;
import dagger.Provides;
import dagger.multibindings.ElementsIntoSet;
import io.deephaven.annotations.BuildableStyle;
import io.deephaven.server.auth.AuthorizationProvider;
import io.deephaven.server.runner.ImmutableTicketResolverOptions;
import io.deephaven.server.session.TicketResolver;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Module
public class TicketResolversFromServiceLoader {
    @Provides
    @ElementsIntoSet
    static Set<TicketResolver> provideTicketResolver(AuthorizationProvider authorizationProvider) {
        ImmutableTicketResolverOptions options = TicketResolverOptions.builder().authorizationProvider(authorizationProvider).build();
        return ServiceLoader.load(Factory.class).stream().map(factory -> ((Factory)factory.get()).create(options)).collect(Collectors.toUnmodifiableSet());
    }

    @Value.Immutable
    @BuildableStyle
    public static abstract class TicketResolverOptions {
        static ImmutableTicketResolverOptions.Builder builder() {
            return ImmutableTicketResolverOptions.builder();
        }

        public abstract AuthorizationProvider authorizationProvider();
    }

    public static interface Factory {
        public TicketResolver create(TicketResolverOptions var1);
    }
}

