/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.runner;

import java.lang.management.ManagementFactory;
import java.util.List;

public final class SafetyChecks {
    public static final String SAFETY_CHECKS_PROPERTY = "deephaven.safetyChecks";
    public static final String SAFETY_CHECKS_ENV = "DEEPHAVEN_SAFETY_CHECKS";

    public static boolean isEnabled() {
        return SafetyChecks.parseBoolean(SAFETY_CHECKS_PROPERTY, SAFETY_CHECKS_ENV, true);
    }

    public static void check() {
        if (!SafetyChecks.isEnabled()) {
            return;
        }
        JDK_8287432.check();
    }

    private static boolean isEnabled(Class<?> clazz) {
        return SafetyChecks.parseBoolean(SafetyChecks.safetyCheckPropertyName(clazz), SafetyChecks.safetyCheckEnvironmentName(clazz), true);
    }

    private static String safetyCheckEnvironmentName(Class<?> clazz) {
        return "DEEPHAVEN_SAFETY_CHECK_" + clazz.getSimpleName();
    }

    private static String safetyCheckPropertyName(Class<?> clazz) {
        return "deephaven.safetyCheck." + clazz.getSimpleName();
    }

    private static boolean parseBoolean(String propertyName, String envName, boolean defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            return Boolean.parseBoolean(propertyValue);
        }
        String envValue = System.getenv(envName);
        if (envValue != null) {
            return Boolean.parseBoolean(envValue);
        }
        return defaultValue;
    }

    private static String disableSafetyCheckMessage(Class<?> clazz) {
        return String.format("To disable this safety check (not recommended), you can set the system property `-D%s=false` or environment variable `%s=false`.", SafetyChecks.safetyCheckPropertyName(clazz), SafetyChecks.safetyCheckEnvironmentName(clazz));
    }

    private static String disableSafetyChecksMessage() {
        return String.format("To disable all safety checks (not recommended), you can set the system property `-D%s=false` or environment variable `%s=false`.", SAFETY_CHECKS_PROPERTY, SAFETY_CHECKS_ENV);
    }

    private static IllegalStateException exception(Class<?> clazz, String baseMessage) {
        return new IllegalStateException(String.format("%s %s %s", baseMessage, SafetyChecks.disableSafetyCheckMessage(clazz), SafetyChecks.disableSafetyChecksMessage()));
    }

    public static final class JDK_8287432 {
        private static void check() {
            if (!SafetyChecks.isEnabled(JDK_8287432.class)) {
                return;
            }
            if (JDK_8287432.isVulnerableVersion() && !JDK_8287432.hasWorkaround()) {
                throw SafetyChecks.exception(JDK_8287432.class, String.format("The current JDK %s (located at %s) is vulnerable to the bug https://bugs.openjdk.org/browse/JDK-8287432. We recommend updating to 11.0.17+, 17.0.5+, or 21+. If that is not possible, you can apply a workaround '%s'.", Runtime.version(), System.getProperty("java.home"), String.join((CharSequence)" ", JDK_8287432.workaroundJvmArguments())));
            }
        }

        private static boolean isVulnerableVersion(Runtime.Version version) {
            switch (version.feature()) {
                case 11: {
                    return version.compareTo(Runtime.Version.parse("11.0.17")) < 0;
                }
                case 17: {
                    return version.compareTo(Runtime.Version.parse("17.0.5")) < 0;
                }
            }
            return false;
        }

        private static boolean isVulnerableVersion() {
            return JDK_8287432.isVulnerableVersion(Runtime.version());
        }

        private static boolean hasWorkaround() {
            return ManagementFactory.getRuntimeMXBean().getInputArguments().contains("-XX:DisableIntrinsic=_currentThread");
        }

        private static List<String> workaroundJvmArguments() {
            return List.of("-XX:+UnlockDiagnosticVMOptions", "-XX:DisableIntrinsic=_currentThread");
        }
    }
}

