/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.runner;

import dev.dirs.ProjectDirectories;
import io.deephaven.base.system.PrintStreamGlobals;
import io.deephaven.configuration.CacheDir;
import io.deephaven.configuration.ConfigDir;
import io.deephaven.configuration.Configuration;
import io.deephaven.configuration.DataDir;
import io.deephaven.engine.table.impl.remote.ConstructSnapshot;
import io.deephaven.internal.log.Bootstrap;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.LogBuffer;
import io.deephaven.io.logger.LogBufferGlobal;
import io.deephaven.io.logger.LogBufferInterceptor;
import io.deephaven.io.logger.Logger;
import io.deephaven.server.runner.SafetyChecks;
import io.deephaven.ssl.config.Identity;
import io.deephaven.ssl.config.IdentityPrivateKey;
import io.deephaven.ssl.config.SSLConfig;
import io.deephaven.ssl.config.Trust;
import io.deephaven.ssl.config.TrustCertificates;
import io.deephaven.util.HeapDump;
import io.deephaven.util.annotations.VisibleForTesting;
import io.deephaven.util.process.ProcessEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class MainHelper {
    public static final String SSL_IDENTITY_TYPE = "ssl.identity.type";
    public static final String SSL_IDENTITY_CERT_CHAIN_PATH = "ssl.identity.certChainPath";
    public static final String SSL_IDENTITY_PRIVATE_KEY_PATH = "ssl.identity.privateKeyPath";
    public static final String SSL_TRUST_TYPE = "ssl.trust.type";
    public static final String SSL_TRUST_PATH = "ssl.trust.path";
    public static final String SSL_CLIENT_AUTH = "ssl.clientAuthentication";
    public static final String PRIVATEKEY = "privatekey";
    public static final String CERTS = "certs";
    public static final String DEEPHAVEN_APPLICATION_PROPERTY = "deephaven.application";
    public static final String DEEPHAVEN_APPLICATION_ENV = "DEEPHAVEN_APPLICATION";

    private static void bootstrapSystemProperties(String[] args) throws IOException {
        if (args.length > 1) {
            throw new IllegalArgumentException("Expected 0 or 1 argument");
        }
        if (args.length == 1) {
            MainHelper.bootstrapFromFile(Path.of(args[0], new String[0]));
            return;
        }
    }

    private static void bootstrapFromFile(Path configFile) throws IOException {
        Bootstrap.printf((String)"# Bootstrapping from file '%s'%n", (Object[])new Object[]{configFile});
        try (BufferedReader reader = Files.newBufferedReader(configFile, Charset.defaultCharset());){
            System.getProperties().load(reader);
        }
    }

    @VisibleForTesting
    public static void bootstrapProjectDirectories() throws IOException {
        String applicationName = MainHelper.applicationProperty().or(MainHelper::applicationEnvironmentVariable).orElse("deephaven");
        ProjectDirectories defaultDirectories = ProjectDirectories.from((String)"io", (String)"Deephaven Data Labs", (String)applicationName);
        Path cacheDir = CacheDir.getOrSet((String)defaultDirectories.cacheDir);
        Path configDir = ConfigDir.getOrSet((String)defaultDirectories.configDir);
        Path dataDir = DataDir.getOrSet((String)defaultDirectories.dataDir);
        Files.createDirectories(cacheDir, new FileAttribute[0]);
        Files.createDirectories(dataDir, new FileAttribute[0]);
        Bootstrap.printf((String)"%s=%s%n%s=%s%n%s=%s%n", (Object[])new Object[]{"deephaven.cacheDir", cacheDir, "deephaven.configDir", configDir, "deephaven.dataDir", dataDir});
    }

    @NotNull
    public static Configuration init(String[] args, Class<?> mainClass) throws IOException {
        Bootstrap.printf((String)"# Starting %s%n", (Object[])new Object[]{mainClass.getName()});
        MainHelper.bootstrapSystemProperties(args);
        MainHelper.bootstrapProjectDirectories();
        PrintStreamGlobals.init();
        SafetyChecks.check();
        LogBufferGlobal.setInstance((LogBuffer)new LogBufferInterceptor(Integer.getInteger("logBuffer.history", 1024).intValue()));
        Logger log = LoggerFactory.getLogger(mainClass);
        log.info().append((CharSequence)"Starting up ").append((CharSequence)mainClass.getName()).append((CharSequence)"...").endl();
        Configuration config = Configuration.getInstance();
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        ProcessEnvironment processEnvironment = ProcessEnvironment.basicInteractiveProcessInitialization((Configuration)config, (String)mainClass.getName(), (Logger)log);
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)processEnvironment.getFatalErrorReporter());
        HeapDump.setupHeapDumpWithDefaults((Configuration)config, unused -> ConstructSnapshot.concurrentAttemptInconsistent(), (Logger)log);
        return config;
    }

    public static Optional<SSLConfig> parseSSLConfig(Configuration config) {
        return MainHelper.parseSSLConfig(null, config, true);
    }

    public static Optional<SSLConfig> parseOutboundSSLConfig(Configuration config) {
        return MainHelper.parseSSLConfig("outbound.", config, false);
    }

    private static Optional<SSLConfig> parseSSLConfig(String prefix, Configuration config, boolean needsIdentity) {
        Optional<Identity> identity = MainHelper.parseIdentityConfig(prefix, config);
        if (needsIdentity && identity.isEmpty()) {
            return Optional.empty();
        }
        SSLConfig.Builder builder = SSLConfig.builder();
        identity.ifPresent(arg_0 -> ((SSLConfig.Builder)builder).identity(arg_0));
        MainHelper.parseTrustConfig(prefix, config).ifPresent(arg_0 -> ((SSLConfig.Builder)builder).trust(arg_0));
        MainHelper.parseClientAuth(prefix, config).ifPresent(arg_0 -> ((SSLConfig.Builder)builder).clientAuthentication(arg_0));
        return Optional.of(builder.build());
    }

    private static Optional<Identity> parseIdentityConfig(String prefix, Configuration config) {
        String identityType = config.getStringWithDefault(MainHelper.prefix(prefix, SSL_IDENTITY_TYPE), null);
        if (identityType == null) {
            return Optional.empty();
        }
        if (!PRIVATEKEY.equals(identityType)) {
            throw new IllegalArgumentException(String.format("Only support `%s` identity type through Configuration", PRIVATEKEY));
        }
        String identityCa = config.getStringWithDefault(MainHelper.prefix(prefix, SSL_IDENTITY_CERT_CHAIN_PATH), null);
        String identityKey = config.getStringWithDefault(MainHelper.prefix(prefix, SSL_IDENTITY_PRIVATE_KEY_PATH), null);
        if (identityCa == null || identityKey == null) {
            throw new IllegalArgumentException(String.format("Must specify `%s` and `%s`", MainHelper.prefix(prefix, SSL_IDENTITY_CERT_CHAIN_PATH), MainHelper.prefix(prefix, SSL_IDENTITY_PRIVATE_KEY_PATH)));
        }
        return Optional.of(IdentityPrivateKey.builder().certChainPath(identityCa).privateKeyPath(identityKey).build());
    }

    private static Optional<? extends Trust> parseTrustConfig(String prefix, Configuration config) {
        String trustType = config.getStringWithDefault(MainHelper.prefix(prefix, SSL_TRUST_TYPE), null);
        if (trustType == null) {
            return Optional.empty();
        }
        if (!CERTS.equals(trustType)) {
            throw new IllegalArgumentException(String.format("Only support `%s` trust type through Configuration", CERTS));
        }
        String trustPath = config.getStringWithDefault(MainHelper.prefix(prefix, SSL_TRUST_PATH), null);
        return Optional.ofNullable(trustPath).map(xva$0 -> TrustCertificates.of((String[])new String[]{xva$0})).or(() -> {
            throw new IllegalArgumentException(String.format("Must specify `%s`", MainHelper.prefix(prefix, SSL_TRUST_PATH)));
        });
    }

    private static Optional<SSLConfig.ClientAuth> parseClientAuth(String prefix, Configuration config) {
        String clientAuth = config.getStringWithDefault(MainHelper.prefix(prefix, SSL_CLIENT_AUTH), null);
        return Optional.ofNullable(clientAuth).map(SSLConfig.ClientAuth::valueOf);
    }

    private static String prefix(String prefix, String key) {
        return prefix != null ? prefix + key : key;
    }

    private static Optional<String> applicationProperty() {
        return Optional.ofNullable(System.getProperty(DEEPHAVEN_APPLICATION_PROPERTY));
    }

    private static Optional<String> applicationEnvironmentVariable() {
        return Optional.ofNullable(System.getenv(DEEPHAVEN_APPLICATION_ENV));
    }
}

