/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.runner;

import io.grpc.Server;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public interface GrpcServer {
    public void start() throws IOException;

    public void join() throws InterruptedException;

    public void beginShutdown();

    public void stopWithTimeout(long var1, TimeUnit var3);

    public int getPort();

    public static GrpcServer of(final Server server) {
        return new GrpcServer(){

            @Override
            public void start() throws IOException {
                server.start();
            }

            @Override
            public void join() throws InterruptedException {
                server.awaitTermination();
            }

            @Override
            public void beginShutdown() {
                server.shutdown();
            }

            @Override
            public void stopWithTimeout(long timeout, TimeUnit unit) {
                server.shutdown();
                Thread shutdownThread = new Thread(() -> {
                    try {
                        if (!server.awaitTermination(timeout, unit)) {
                            server.shutdownNow();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                });
                shutdownThread.start();
            }

            @Override
            public int getPort() {
                return server.getPort();
            }
        };
    }
}

