/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.runner;

import io.deephaven.auth.AuthenticationRequestHandler;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.liveness.LivenessScopeStack;
import io.deephaven.engine.table.impl.perf.QueryPerformanceRecorderState;
import io.deephaven.engine.table.impl.util.AsyncErrorLogger;
import io.deephaven.engine.table.impl.util.EngineMetrics;
import io.deephaven.engine.table.impl.util.ServerStateTracker;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.engine.updategraph.impl.PeriodicUpdateGraph;
import io.deephaven.engine.util.ScriptSession;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.server.appmode.ApplicationInjector;
import io.deephaven.server.config.ServerConfig;
import io.deephaven.server.log.LogInit;
import io.deephaven.server.plugin.PluginRegistration;
import io.deephaven.server.runner.GrpcServer;
import io.deephaven.server.session.SessionFactoryCreator;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.util.Scheduler;
import io.deephaven.time.calendar.BusinessCalendar;
import io.deephaven.time.calendar.Calendars;
import io.deephaven.uri.resolver.UriResolver;
import io.deephaven.uri.resolver.UriResolvers;
import io.deephaven.uri.resolver.UriResolversInstance;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.annotations.InternalUseOnly;
import io.deephaven.util.annotations.ScriptApi;
import io.deephaven.util.annotations.VisibleForTesting;
import io.deephaven.util.process.ProcessEnvironment;
import io.deephaven.util.process.ShutdownManager;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;

public class DeephavenApiServer {
    private static final Logger log = LoggerFactory.getLogger(DeephavenApiServer.class);
    private static final long CHECK_SCOPE_CHANGES_INTERVAL_MILLIS = Configuration.getInstance().getLongForClassWithDefault(DeephavenApiServer.class, "checkScopeChangesIntervalMillis", 100L);
    private static DeephavenApiServer INSTANCE;
    private final GrpcServer server;
    private final UpdateGraph ug;
    private final Provider<LogInit> logInit;
    private final Provider<Set<BusinessCalendar>> calendars;
    private final Scheduler scheduler;
    private final Provider<ScriptSession> scriptSessionProvider;
    private final PluginRegistration pluginRegistration;
    private final ApplicationInjector applicationInjector;
    private final UriResolvers uriResolvers;
    private final SessionService sessionService;
    private final Map<String, AuthenticationRequestHandler> authenticationHandlers;
    private final Provider<ExecutionContext> executionContextProvider;
    private final ServerConfig serverConfig;
    private final SessionFactoryCreator sessionFactoryCreator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InternalUseOnly
    public static DeephavenApiServer getInstance() {
        Class<DeephavenApiServer> clazz = DeephavenApiServer.class;
        synchronized (DeephavenApiServer.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return Objects.requireNonNull(INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInstance(DeephavenApiServer instance) {
        Objects.requireNonNull(instance);
        Class<DeephavenApiServer> clazz = DeephavenApiServer.class;
        synchronized (DeephavenApiServer.class) {
            if (INSTANCE != null) {
                throw new IllegalStateException();
            }
            INSTANCE = instance;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearInstance(DeephavenApiServer expected) {
        Objects.requireNonNull(expected);
        Class<DeephavenApiServer> clazz = DeephavenApiServer.class;
        synchronized (DeephavenApiServer.class) {
            if (INSTANCE != expected) {
                throw new IllegalStateException();
            }
            INSTANCE = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Inject
    public DeephavenApiServer(GrpcServer server, @Named(value="DEFAULT") UpdateGraph ug, Provider<LogInit> logInit, Provider<Set<BusinessCalendar>> calendars, Scheduler scheduler, Provider<ScriptSession> scriptSessionProvider, PluginRegistration pluginRegistration, ApplicationInjector applicationInjector, UriResolvers uriResolvers, SessionService sessionService, Map<String, AuthenticationRequestHandler> authenticationHandlers, Provider<ExecutionContext> executionContextProvider, ServerConfig serverConfig, SessionFactoryCreator sessionFactoryCreator) {
        this.server = server;
        this.ug = ug;
        this.logInit = logInit;
        this.calendars = calendars;
        this.scheduler = scheduler;
        this.scriptSessionProvider = scriptSessionProvider;
        this.pluginRegistration = pluginRegistration;
        this.applicationInjector = applicationInjector;
        this.uriResolvers = uriResolvers;
        this.sessionService = sessionService;
        this.authenticationHandlers = authenticationHandlers;
        this.executionContextProvider = executionContextProvider;
        this.serverConfig = serverConfig;
        this.sessionFactoryCreator = sessionFactoryCreator;
    }

    @VisibleForTesting
    public GrpcServer server() {
        return this.server;
    }

    @VisibleForTesting
    public SessionService sessionService() {
        return this.sessionService;
    }

    public DeephavenApiServer run() throws IOException, ClassNotFoundException, TimeoutException {
        DeephavenApiServer.setInstance(this);
        ProcessEnvironment.getGlobalShutdownManager().registerTask(ShutdownManager.OrderingCategory.FIRST, this.server::beginShutdown);
        ProcessEnvironment.getGlobalShutdownManager().registerTask(ShutdownManager.OrderingCategory.MIDDLE, this.sessionService::onShutdown);
        ProcessEnvironment.getGlobalShutdownManager().registerTask(ShutdownManager.OrderingCategory.MIDDLE, () -> ((ScriptSession)this.scriptSessionProvider.get()).cleanup());
        ProcessEnvironment.getGlobalShutdownManager().registerTask(ShutdownManager.OrderingCategory.LAST, () -> {
            try {
                Duration duration = this.serverConfig.shutdownTimeout();
                this.server.stopWithTimeout(duration.toNanos(), TimeUnit.NANOSECONDS);
                this.server.join();
                DeephavenApiServer.clearInstance(this);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        log.info().append((CharSequence)"Configuring logging...").endl();
        this.logInit.get();
        for (BusinessCalendar calendar : (Set)this.calendars.get()) {
            Calendars.addCalendar((BusinessCalendar)calendar);
        }
        log.info().append((CharSequence)"Initializing Script Session...").endl();
        this.checkScopeChanges((ScriptSession)this.scriptSessionProvider.get());
        this.pluginRegistration.registerAll();
        log.info().append((CharSequence)"Initializing Execution Context for Main Thread...").endl();
        ((ExecutionContext)this.executionContextProvider.get()).open();
        log.info().append((CharSequence)"Starting Update Graph...").endl();
        ((PeriodicUpdateGraph)this.getUpdateGraph().cast()).start();
        EngineMetrics.maybeStartStatsCollection();
        log.info().append((CharSequence)"Starting Performance Trackers...").endl();
        QueryPerformanceRecorderState.installPoolAllocationRecorder();
        QueryPerformanceRecorderState.installUpdateGraphLockInstrumentation();
        ServerStateTracker.start();
        AsyncErrorLogger.init();
        for (UriResolver resolver : this.uriResolvers.resolvers()) {
            log.debug().append((CharSequence)"Found table resolver ").append((CharSequence)resolver.getClass().toString()).endl();
        }
        UriResolversInstance.init((UriResolvers)this.uriResolvers);
        this.applicationInjector.run();
        log.info().append((CharSequence)"Initializing Authentication...").endl();
        String targetUrl = this.serverConfig.targetUrlOrDefault();
        this.authenticationHandlers.forEach((name, handler) -> handler.initialize(targetUrl));
        log.info().append((CharSequence)"Starting server...").endl();
        this.server.start();
        log.info().append((CharSequence)"Server started on port ").append(this.server.getPort()).endl();
        return this;
    }

    private void checkScopeChanges(ScriptSession scriptSession) {
        try (SafeCloseable ignored = LivenessScopeStack.open();){
            scriptSession.observeScopeChanges();
        }
        this.scheduler.runAfterDelay(CHECK_SCOPE_CHANGES_INTERVAL_MILLIS, () -> this.checkScopeChanges(scriptSession));
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    void startForUnitTests() throws Exception {
        DeephavenApiServer.setInstance(this);
        try {
            this.pluginRegistration.registerAll();
            this.applicationInjector.run();
            ((ExecutionContext)this.executionContextProvider.get()).getQueryLibrary().updateVersionString("DEFAULT");
            log.info().append((CharSequence)"Starting server...").endl();
            this.server.start();
        }
        catch (Exception e) {
            DeephavenApiServer.clearInstance(this);
            throw e;
        }
    }

    void teardownForUnitTests() throws InterruptedException {
        try {
            this.server.stopWithTimeout(5L, TimeUnit.SECONDS);
            this.server.join();
        }
        finally {
            DeephavenApiServer.clearInstance(this);
        }
    }

    @VisibleForTesting
    public UpdateGraph getUpdateGraph() {
        return this.ug;
    }

    @InternalUseOnly
    @ScriptApi
    public SessionFactoryCreator sessionFactoryCreator() {
        return this.sessionFactoryCreator;
    }
}

