/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.resources;

import io.deephaven.configuration.Configuration;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.server.resources.ServerResource;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public class ServerResources {
    private static final Logger log = LoggerFactory.getLogger(ServerResources.class);
    private static final String CONFIG_PREFIX = "http.resources.";

    public static List<String> resourcesFromServiceLoader(Configuration configuration) {
        Properties properties = configuration.getProperties(CONFIG_PREFIX);
        List resources = ServiceLoader.load(ServerResource.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
        HashMap<String, Integer> priorities = new HashMap<String, Integer>();
        for (ServerResource resource2 : resources) {
            Object enabled = properties.get(resource2.getName() + ".enabled");
            if (enabled != null && !Boolean.parseBoolean(enabled.toString())) continue;
            Object priority = properties.get(resource2.getName() + ".priority");
            if (priority == null) {
                priorities.put(resource2.getName(), Integer.MAX_VALUE);
                continue;
            }
            priorities.put(resource2.getName(), Integer.parseInt(priority.toString()));
        }
        return resources.stream().filter(res -> priorities.containsKey(res.getName())).sorted(Comparator.comparing(res -> (Integer)priorities.get(res.getName()))).peek(resource -> log.debug().append((CharSequence)"Loading resource: ").append((CharSequence)resource.getName()).append((CharSequence)" with priority: ").append((Integer)priorities.get(resource.getName())).endl()).map(ServerResource::getResourceBaseUrl).collect(Collectors.toList());
    }
}

