/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.plugin.type;

import io.deephaven.plugin.type.ObjectType;
import io.deephaven.plugin.type.ObjectTypeClassBase;
import io.deephaven.plugin.type.ObjectTypeLookup;
import io.deephaven.plugin.type.ObjectTypeRegistration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;

@Singleton
public final class ObjectTypes
implements ObjectTypeLookup,
ObjectTypeRegistration {
    private static final Set<String> RESERVED_TYPE_NAMES_LOWERCASE = Set.of("table", "rolluptable", "treetable", "");
    private final Set<String> namesLowercase = new HashSet<String>();
    private final Map<Class<?>, ObjectType> classTypes = new HashMap();
    private final List<ObjectType> otherTypes = new ArrayList<ObjectType>();

    @Inject
    public ObjectTypes() {
    }

    public synchronized Optional<ObjectType> findObjectType(Object object) {
        ObjectType byClass = this.classTypes.get(object.getClass());
        if (byClass != null) {
            return Optional.of(byClass);
        }
        for (ObjectType type : this.otherTypes) {
            if (!type.isType(object)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    public synchronized void register(ObjectType objectType) {
        String name = objectType.name();
        String nameLowercase = name.toLowerCase(Locale.ENGLISH);
        if (SourceVersion.isKeyword(nameLowercase)) {
            throw new IllegalArgumentException("Unable to register type, name is keyword: " + name);
        }
        if (ObjectTypes.isReservedName(nameLowercase)) {
            throw new IllegalArgumentException("Unable to register type, name is reserved: " + name);
        }
        if (this.namesLowercase.contains(nameLowercase)) {
            throw new IllegalArgumentException("Unable to register type, type name already registered: " + name);
        }
        if (objectType instanceof ObjectTypeClassBase) {
            Class clazz = ((ObjectTypeClassBase)objectType).clazz();
            if (this.classTypes.putIfAbsent(clazz, objectType) != null) {
                throw new IllegalArgumentException("Unable to register type, class already registered: " + String.valueOf(clazz));
            }
        } else {
            this.otherTypes.add(objectType);
        }
        this.namesLowercase.add(nameLowercase);
    }

    private static boolean isReservedName(String name) {
        return RESERVED_TYPE_NAMES_LOWERCASE.contains(name);
    }
}

