/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.plugin.python;

import io.deephaven.plugin.type.Exporter;
import io.deephaven.plugin.type.ObjectCommunicationException;
import io.deephaven.plugin.type.ObjectType;
import io.deephaven.plugin.type.ObjectTypeBase;
import io.deephaven.server.plugin.python.ExporterAdapter;
import io.deephaven.server.plugin.python.LivePyObjectWrapper;
import io.deephaven.util.annotations.ScriptApi;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.jpy.PyObject;

final class ObjectTypeAdapter
extends ObjectTypeBase
implements AutoCloseable {
    private final String name;
    private final PyObject objectTypeAdapter;

    public ObjectTypeAdapter(String name, PyObject objectTypeAdapter) {
        this.name = Objects.requireNonNull(name);
        this.objectTypeAdapter = Objects.requireNonNull(objectTypeAdapter);
    }

    public String name() {
        return this.name;
    }

    public boolean isType(Object object) {
        PyObject pyObject;
        if (object instanceof LivePyObjectWrapper) {
            pyObject = ((LivePyObjectWrapper)((Object)object)).getPythonObject();
        } else if (object instanceof PyObject) {
            pyObject = (PyObject)object;
        } else {
            return false;
        }
        return (Boolean)this.objectTypeAdapter.call(Boolean.TYPE, "is_type", PyObject.class, (Object)pyObject);
    }

    public ObjectType.MessageStream compatibleClientConnection(Object object, ObjectType.MessageStream connection) throws ObjectCommunicationException {
        PyObject pyObject;
        if (object instanceof LivePyObjectWrapper) {
            pyObject = ((LivePyObjectWrapper)((Object)object)).getPythonObject();
        } else if (object instanceof PyObject) {
            pyObject = (PyObject)object;
        } else {
            throw new IllegalStateException(String.valueOf(object) + " is not a python object");
        }
        if (this.objectTypeAdapter.call("is_fetch_only", new Object[0]).getBooleanValue()) {
            Exporter exporter = new Exporter();
            byte[] bytes = (byte[])this.objectTypeAdapter.call(byte[].class, "to_bytes", ExporterAdapter.class, (Object)new ExporterAdapter(exporter), PyObject.class, (Object)pyObject);
            connection.onData(ByteBuffer.wrap(bytes), exporter.references());
            connection.onClose();
            return ObjectType.MessageStream.NOOP;
        }
        PyObject newConnection = (PyObject)this.objectTypeAdapter.call(PyObject.class, "create_client_connection", PyObject.class, (Object)pyObject, PythonClientMessageStream.class, (Object)new PythonClientMessageStream(connection));
        return new PythonServerMessageStream(newConnection);
    }

    public String toString() {
        return this.objectTypeAdapter.toString();
    }

    @Override
    public void close() {
        this.objectTypeAdapter.close();
    }

    private static class PythonClientMessageStream {
        private final ObjectType.MessageStream delegate;

        private PythonClientMessageStream(ObjectType.MessageStream delegate) {
            this.delegate = delegate;
        }

        @ScriptApi
        public void onData(byte[] payload, Object ... references) throws ObjectCommunicationException {
            this.delegate.onData(ByteBuffer.wrap(payload), references);
        }

        @ScriptApi
        public void onClose() {
            this.delegate.onClose();
        }
    }

    private static class PythonServerMessageStream
    implements ObjectType.MessageStream {
        private final PyObject instance;

        private PythonServerMessageStream(PyObject instance) {
            this.instance = instance;
        }

        public void onData(ByteBuffer payload, Object[] references) {
            byte[] bytes = new byte[payload.limit()];
            payload.get(bytes);
            Object[] pyReferences = new Object[references.length];
            for (int i = 0; i < references.length; ++i) {
                Object reference = references[i];
                if (reference instanceof LivePyObjectWrapper) {
                    reference = ((LivePyObjectWrapper)((Object)reference)).getPythonObject();
                }
                pyReferences[i] = reference;
            }
            this.instance.call(Void.TYPE, "on_data", byte[].class, (Object)bytes, Object[].class, (Object)pyReferences);
        }

        public void onClose() {
            this.instance.call("on_close", new Object[0]);
            this.instance.close();
        }
    }
}

