/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.plugin.js;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.deephaven.annotations.SimpleStyle;
import io.deephaven.server.plugin.js.ImmutableNpmPackage;
import io.deephaven.server.plugin.js.Jackson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
abstract class NpmPackage {
    NpmPackage() {
    }

    @JsonCreator
    public static NpmPackage of(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="version", required=true) String version, @JsonProperty(value="main", required=true) String main) {
        return ImmutableNpmPackage.of(name, version, main);
    }

    public static NpmPackage read(Path packageJson) throws IOException {
        try (InputStream in = Files.newInputStream(packageJson, new OpenOption[0]);){
            NpmPackage npmPackage = (NpmPackage)Jackson.OBJECT_MAPPER.readValue(in, NpmPackage.class);
            return npmPackage;
        }
    }

    @JsonProperty(value="name")
    @Value.Parameter
    public abstract String name();

    @JsonProperty(value="version")
    @Value.Parameter
    public abstract String version();

    @JsonProperty(value="main")
    @Value.Parameter
    public abstract String main();
}

