/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.plugin.js;

import io.deephaven.plugin.js.JsPlugin;
import io.deephaven.server.plugin.js.JsPluginManifest;
import io.deephaven.server.plugin.js.JsPluginManifestEntry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

class JsPluginsFromManifest {
    JsPluginsFromManifest() {
    }

    static List<JsPlugin> of(Path manifestRoot) throws IOException {
        JsPluginManifest manifest = JsPluginManifest.read(manifestRoot.resolve("manifest.json"));
        ArrayList<JsPlugin> plugins = new ArrayList<JsPlugin>(manifest.plugins().size());
        for (JsPluginManifestEntry entry : manifest.plugins()) {
            Path pluginPath = manifestRoot.resolve(entry.name());
            Path pluginMain = pluginPath.relativize(pluginPath.resolve(entry.main()));
            JsPlugin plugin = JsPlugin.builder().name(entry.name()).version(entry.version()).main(pluginMain).path(pluginPath).build();
            plugins.add(plugin);
        }
        return plugins;
    }
}

