/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.plugin.js;

import dagger.Binds;
import dagger.multibindings.IntoSet;
import io.deephaven.configuration.Configuration;
import io.deephaven.plugin.Plugin;
import io.deephaven.plugin.Registration;
import io.deephaven.plugin.js.JsPlugin;
import io.deephaven.server.plugin.js.JsPluginFromNpmPackage;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public final class JsPluginNpmPackageRegistration
implements Registration {
    public static final String PACKAGE_JSON = "package.json";
    public static final String NAME = "name";
    public static final String VERSION = "version";
    public static final String MAIN = "main";

    @Inject
    JsPluginNpmPackageRegistration() {
    }

    public void registerInto(Registration.Callback callback) {
        Configuration config = Configuration.getInstance();
        Set<String> parts = JsPluginNpmPackageRegistration.partsThatStartWith("deephaven.jsPlugins.", config);
        for (String part : parts) {
            JsPlugin plugin;
            String packageRoot;
            String propertyName = "deephaven.jsPlugins." + part;
            if ("deephaven.jsPlugins.resourceBase".equals(propertyName) || (packageRoot = config.getStringWithDefault(propertyName, null)) == null) continue;
            URI uri = URI.create(packageRoot);
            if (uri.getScheme() == null) {
                uri = URI.create("file:" + packageRoot);
            }
            FileSystem fileSystem = JsPluginNpmPackageRegistration.getOrCreateFileSystem(uri);
            try {
                plugin = JsPluginFromNpmPackage.of(fileSystem.provider().getPath(uri));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            callback.register((Plugin)plugin);
        }
    }

    private static FileSystem getOrCreateFileSystem(URI uri) {
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            return FileSystems.getDefault();
        }
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            try {
                return FileSystems.newFileSystem(uri, Map.of());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static Set<String> partsThatStartWith(String prefix, Configuration configuration) {
        HashSet<String> parts = new HashSet<String>();
        Iterator<Object> it = configuration.getProperties(prefix).keys().asIterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof String)) continue;
            parts.add(JsPluginNpmPackageRegistration.firstPart((String)next));
        }
        return parts;
    }

    private static String firstPart(String x) {
        int index = x.indexOf(46);
        return index == -1 ? x : x.substring(0, index);
    }

    @dagger.Module
    public static interface Module {
        @Binds
        @IntoSet
        public Registration bindsRegistration(JsPluginNpmPackageRegistration var1);
    }
}

