/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.plugin.js;

import dagger.Binds;
import dagger.multibindings.IntoSet;
import io.deephaven.configuration.Configuration;
import io.deephaven.plugin.Plugin;
import io.deephaven.plugin.Registration;
import io.deephaven.plugin.js.JsPlugin;
import io.deephaven.server.plugin.js.JsPluginsFromManifest;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;

public final class JsPluginManifestRegistration
implements Registration {
    public static final String JS_PLUGIN_RESOURCE_BASE = "deephaven.jsPlugins.resourceBase";

    @Inject
    JsPluginManifestRegistration() {
    }

    public void registerInto(Registration.Callback callback) {
        List<JsPlugin> plugins;
        String resourceBase = Configuration.getInstance().getStringWithDefault(JS_PLUGIN_RESOURCE_BASE, null);
        if (resourceBase == null) {
            return;
        }
        try {
            plugins = JsPluginsFromManifest.of(Path.of(resourceBase, new String[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        for (JsPlugin plugin : plugins) {
            callback.register((Plugin)plugin);
        }
    }

    @dagger.Module
    public static interface Module {
        @Binds
        @IntoSet
        public Registration bindsRegistration(JsPluginManifestRegistration var1);
    }
}

