/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.plugin.js;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.deephaven.annotations.SimpleStyle;
import io.deephaven.plugin.js.JsPlugin;
import io.deephaven.server.plugin.js.ImmutableJsPluginManifest;
import io.deephaven.server.plugin.js.Jackson;
import io.deephaven.server.plugin.js.JsPluginManifestEntry;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class JsPluginManifest {
    public static final String PLUGINS = "plugins";
    public static final String MANIFEST_JSON = "manifest.json";

    @JsonCreator
    public static JsPluginManifest of(@JsonProperty(value="plugins", required=true) List<JsPluginManifestEntry> plugins) {
        return ImmutableJsPluginManifest.of(plugins);
    }

    public static JsPluginManifest from(List<JsPlugin> plugins) {
        return JsPluginManifest.of(plugins.stream().map(JsPluginManifestEntry::from).collect(Collectors.toList()));
    }

    static JsPluginManifest read(Path manifestJson) throws IOException {
        try (InputStream in = Files.newInputStream(manifestJson, new OpenOption[0]);){
            JsPluginManifest jsPluginManifest = (JsPluginManifest)Jackson.OBJECT_MAPPER.readValue(in, JsPluginManifest.class);
            return jsPluginManifest;
        }
    }

    @JsonProperty(value="plugins")
    @Value.Parameter
    public abstract List<JsPluginManifestEntry> plugins();
}

