/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.plugin.js;

import dagger.Binds;
import dagger.multibindings.IntoSet;
import io.deephaven.configuration.ConfigDir;
import io.deephaven.plugin.Plugin;
import io.deephaven.plugin.Registration;
import io.deephaven.plugin.js.JsPlugin;
import io.deephaven.server.plugin.js.JsPluginsFromManifest;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;

public final class JsPluginConfigDirRegistration
implements Registration {
    public static final String JS_PLUGINS = "js-plugins";

    @Inject
    JsPluginConfigDirRegistration() {
    }

    public void registerInto(Registration.Callback callback) {
        List<JsPlugin> plugins;
        Path manifestRoot = ConfigDir.get().map(p -> p.resolve(JS_PLUGINS).resolve("manifest.json")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::getParent).orElse(null);
        if (manifestRoot == null) {
            return;
        }
        try {
            plugins = JsPluginsFromManifest.of(manifestRoot);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        for (JsPlugin plugin : plugins) {
            callback.register((Plugin)plugin);
        }
    }

    @dagger.Module
    public static interface Module {
        @Binds
        @IntoSet
        public Registration bindsRegistration(JsPluginConfigDirRegistration var1);
    }
}

