/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.plugin;

import io.deephaven.plugin.Plugin;
import io.deephaven.plugin.Registration;
import io.deephaven.plugin.js.JsPlugin;
import io.deephaven.plugin.js.JsPluginRegistration;
import io.deephaven.plugin.type.ObjectType;
import io.deephaven.plugin.type.ObjectTypeRegistration;
import java.util.Objects;
import javax.inject.Inject;

final class PluginRegistrationVisitor
implements Registration.Callback,
Plugin.Visitor<PluginRegistrationVisitor> {
    private final ObjectTypeRegistration objectTypeRegistration;
    private final JsPluginRegistration jsPluginRegistration;

    @Inject
    PluginRegistrationVisitor(ObjectTypeRegistration objectTypeRegistration, JsPluginRegistration jsPluginRegistration) {
        this.objectTypeRegistration = Objects.requireNonNull(objectTypeRegistration);
        this.jsPluginRegistration = Objects.requireNonNull(jsPluginRegistration);
    }

    public void register(Plugin plugin) {
        plugin.walk((Plugin.Visitor)this);
    }

    public PluginRegistrationVisitor visit(ObjectType objectType) {
        this.objectTypeRegistration.register(objectType);
        return this;
    }

    public PluginRegistrationVisitor visit(JsPlugin jsPlugin) {
        this.jsPluginRegistration.register(jsPlugin);
        return this;
    }
}

