/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.plugin;

import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.plugin.Plugin;
import io.deephaven.plugin.Registration;
import io.deephaven.plugin.js.JsPlugin;
import io.deephaven.plugin.type.ObjectType;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public final class PluginRegistration {
    private static final Logger log = LoggerFactory.getLogger(PluginRegistration.class);
    private final Set<Registration> registrations;
    private final Registration.Callback callback;

    @Inject
    public PluginRegistration(Set<Registration> registrations, Registration.Callback callback) {
        this.registrations = Objects.requireNonNull(registrations);
        this.callback = Objects.requireNonNull(callback);
    }

    public void registerAll() {
        log.info().append((CharSequence)"Registering plugins...").endl();
        Counting counting = new Counting();
        for (Registration registration : this.registrations) {
            log.info().append((CharSequence)"Invoking registration: ").append((CharSequence)registration.toString()).endl();
            registration.registerInto((Registration.Callback)counting);
        }
        log.info().append((CharSequence)"Registered plugins: ").append((LogOutputAppendable)counting).endl();
    }

    private class Counting
    implements Registration.Callback,
    LogOutputAppendable,
    Plugin.Visitor<Counting> {
        private int objectTypeCount = 0;
        private int jsCount = 0;

        private Counting() {
        }

        public void register(Plugin plugin) {
            plugin.walk((Plugin.Visitor)this);
        }

        public Counting visit(ObjectType objectType) {
            log.info().append((CharSequence)"Registering object type: ").append((CharSequence)objectType.name()).append((CharSequence)" / ").append((CharSequence)objectType.toString()).endl();
            PluginRegistration.this.callback.register((Plugin)objectType);
            ++this.objectTypeCount;
            return this;
        }

        public Counting visit(JsPlugin jsPlugin) {
            log.info().append((CharSequence)"Registering jsPlugin ").append((CharSequence)jsPlugin.toString()).endl();
            PluginRegistration.this.callback.register((Plugin)jsPlugin);
            ++this.jsCount;
            return this;
        }

        public LogOutput append(LogOutput logOutput) {
            return logOutput.append((CharSequence)"objectType=").append(this.objectTypeCount).append((CharSequence)",js=").append(this.jsCount);
        }
    }
}

