/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.partitionedtable;

import com.google.protobuf.Message;
import com.google.rpc.Code;
import io.deephaven.auth.codegen.impl.PartitionedTableServiceContextualAuthWiring;
import io.deephaven.engine.exceptions.UpdateGraphConflictException;
import io.deephaven.engine.table.PartitionedTable;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.partitioned.PartitionedTableImpl;
import io.deephaven.engine.table.impl.perf.QueryPerformanceNugget;
import io.deephaven.engine.table.impl.perf.QueryPerformanceRecorder;
import io.deephaven.engine.updategraph.NotificationQueue;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.extensions.barrage.util.ExportUtil;
import io.deephaven.extensions.barrage.util.GrpcUtil;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse;
import io.deephaven.proto.backplane.grpc.GetTableRequest;
import io.deephaven.proto.backplane.grpc.MergeRequest;
import io.deephaven.proto.backplane.grpc.PartitionByRequest;
import io.deephaven.proto.backplane.grpc.PartitionByResponse;
import io.deephaven.proto.backplane.grpc.PartitionedTableServiceGrpc;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.grpc.GrpcErrorHelper;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.session.TicketRouter;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.annotations.TestUseOnly;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class PartitionedTableServiceGrpcImpl
extends PartitionedTableServiceGrpc.PartitionedTableServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(PartitionedTableServiceGrpcImpl.class);
    private final TicketRouter ticketRouter;
    private final SessionService sessionService;
    private final PartitionedTableServiceContextualAuthWiring authWiring;

    @Inject
    public PartitionedTableServiceGrpcImpl(TicketRouter ticketRouter, SessionService sessionService, PartitionedTableServiceContextualAuthWiring authWiring) {
        this.ticketRouter = ticketRouter;
        this.sessionService = sessionService;
        this.authWiring = authWiring;
    }

    public void partitionBy(@NotNull PartitionByRequest request, @NotNull StreamObserver<PartitionByResponse> responseObserver) {
        GrpcErrorHelper.checkHasNoUnknownFieldsRecursive((Message)request);
        SessionState session = this.sessionService.getCurrentSession();
        String description = "PartitionedTableService#partitionBy(table=" + this.ticketRouter.getLogNameFor(request.getTableId(), "tableId") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject targetTable = this.ticketRouter.resolve(session, request.getTableId(), "tableId");
            session.newExport(request.getResultId(), "resultId").queryPerformanceRecorder(queryPerformanceRecorder).require(targetTable).onError(responseObserver).onSuccess(ignoredResult -> GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)PartitionByResponse.getDefaultInstance())).submit(() -> {
                this.authWiring.checkPermissionPartitionBy(session.getAuthContext(), request, Collections.singletonList((Table)targetTable.get()));
                PartitionedTable partitionedTable = ((Table)targetTable.get()).partitionBy(request.getDropKeys(), (String[])request.getKeyColumnNamesList().toArray(String[]::new));
                return partitionedTable;
            });
        }
    }

    public void merge(@NotNull MergeRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        GrpcErrorHelper.checkHasNoUnknownFieldsRecursive((Message)request);
        SessionState session = this.sessionService.getCurrentSession();
        String description = "PartitionedTableService#merge(table=" + this.ticketRouter.getLogNameFor(request.getPartitionedTable(), "partitionedTable") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject partitionedTable = this.ticketRouter.resolve(session, request.getPartitionedTable(), "partitionedTable");
            session.newExport(request.getResultId(), "resultId").queryPerformanceRecorder(queryPerformanceRecorder).require(partitionedTable).onError(responseObserver).onSuccess(merged -> GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)ExportUtil.buildTableCreationResponse((Ticket)request.getResultId(), (Table)merged))).submit(() -> {
                Table table = ((PartitionedTable)partitionedTable.get()).table();
                this.authWiring.checkPermissionMerge(session.getAuthContext(), request, Collections.singletonList(table));
                Table merged = table.isRefreshing() ? (Table)table.getUpdateGraph().sharedLock().computeLocked(() -> ((PartitionedTable)((PartitionedTable)partitionedTable.get())).merge()) : ((PartitionedTable)partitionedTable.get()).merge();
                return merged;
            });
        }
    }

    public void getTable(@NotNull GetTableRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        GrpcErrorHelper.checkHasNoUnknownFieldsRecursive((Message)request);
        SessionState session = this.sessionService.getCurrentSession();
        String description = "PartitionedTableService#getTable(table=" + this.ticketRouter.getLogNameFor(request.getPartitionedTable(), "partitionedTable") + ", keyTable=" + this.ticketRouter.getLogNameFor(request.getKeyTableTicket(), "keyTable") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject partitionedTable = this.ticketRouter.resolve(session, request.getPartitionedTable(), "partitionedTable");
            SessionState.ExportObject keys = this.ticketRouter.resolve(session, request.getKeyTableTicket(), "keyTable");
            session.newExport(request.getResultId(), "resultId").queryPerformanceRecorder(queryPerformanceRecorder).require(partitionedTable, keys).onError(responseObserver).onSuccess(table -> GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)ExportUtil.buildTableCreationResponse((Ticket)request.getResultId(), (Table)table))).submit(() -> {
                Table keyTable = (Table)keys.get();
                this.authWiring.checkPermissionGetTable(session.getAuthContext(), request, List.of(((PartitionedTable)partitionedTable.get()).table(), keyTable));
                Table table = this.lockAndGetConstituents(request, keyTable, (PartitionedTable)partitionedTable.get());
                return table;
            });
        }
    }

    @TestUseOnly
    Table lockAndGetConstituents(@NotNull GetTableRequest request, Table keyTable, PartitionedTable partitionedTable) {
        boolean requiresLock;
        boolean bl = requiresLock = keyTable.isRefreshing() || partitionedTable.table().isRefreshing();
        if (requiresLock) {
            try {
                UpdateGraph updateGraph = keyTable.getUpdateGraph(new NotificationQueue.Dependency[]{partitionedTable.table()});
                return (Table)updateGraph.sharedLock().computeLocked(() -> this.getConstituents(request, keyTable, partitionedTable));
            }
            catch (UpdateGraphConflictException ugce) {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Provided key table UpdateGraph is inconsistent with PartitionedTable UpdateGraph");
            }
        }
        return this.getConstituents(request, keyTable, partitionedTable);
    }

    @TestUseOnly
    Table getConstituents(@NotNull GetTableRequest request, Table keyTable, PartitionedTable partitionedTable) {
        long keyTableSize;
        boolean uniqueStaticResult;
        switch (request.getUniqueBehavior()) {
            case NOT_SET_UNIQUE_BEHAVIOR: 
            case REQUIRE_UNIQUE_RESULTS_STATIC_SINGLE_KEY: {
                uniqueStaticResult = true;
                break;
            }
            case PERMIT_MULTIPLE_KEYS: {
                uniqueStaticResult = false;
                break;
            }
            default: {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Invalid unique behavior " + request.getUniqueBehaviorValue()));
            }
        }
        if (uniqueStaticResult && (keyTableSize = keyTable.size()) != 1L) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Provided key table does not have one row, instead has " + keyTableSize));
        }
        Table requestedRows = (Table)partitionedTable.table().whereIn((Object)keyTable, (String[])partitionedTable.keyColumnNames().toArray(String[]::new));
        if (uniqueStaticResult) {
            long resultPartitionsSize = requestedRows.size();
            if (resultPartitionsSize != 1L) {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Filtered PartitionedTable has more than one constituent, " + resultPartitionsSize + " constituents found"));
            }
            return (Table)requestedRows.getColumnSource(partitionedTable.constituentColumnName(), Table.class).get(requestedRows.getRowSet().firstRowKey());
        }
        return new PartitionedTableImpl(requestedRows, (Collection)partitionedTable.keyColumnNames(), partitionedTable.uniqueKeys(), partitionedTable.constituentColumnName(), partitionedTable.constituentDefinition(), true, false).merge();
    }
}

