/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.object;

import com.google.protobuf.Message;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.backplane.grpc.BrowserNextResponse;
import io.deephaven.proto.backplane.grpc.ObjectServiceGrpc;
import io.deephaven.proto.backplane.grpc.StreamRequest;
import io.deephaven.proto.backplane.grpc.StreamResponse;
import io.deephaven.server.auth.AuthorizationProvider;
import io.deephaven.server.browserstreaming.BrowserStream;
import io.deephaven.server.object.ObjectServiceGrpcImpl;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.util.GrpcServiceOverrideBuilder;
import io.grpc.BindableService;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ObjectServiceGrpcBinding
implements BindableService {
    private static final Logger log = LoggerFactory.getLogger(ObjectServiceGrpcBinding.class);
    private final AuthorizationProvider authProvider;
    private final ObjectServiceGrpcImpl delegate;
    private final SessionService sessionService;

    @Inject
    public ObjectServiceGrpcBinding(AuthorizationProvider authProvider, ObjectServiceGrpcImpl delegate, SessionService sessionService) {
        this.authProvider = authProvider;
        this.delegate = delegate;
        this.sessionService = sessionService;
    }

    public ServerServiceDefinition bindService() {
        ServerServiceDefinition authIntercepted = this.authProvider.getObjectServiceAuthWiring().intercept((ObjectServiceGrpc.ObjectServiceImplBase)this.delegate);
        return GrpcServiceOverrideBuilder.newBuilder(authIntercepted).onBidiOverrideWithBrowserSupport(this.delegate::messageStream, ObjectServiceGrpc.getMessageStreamMethod(), ObjectServiceGrpc.getOpenMessageStreamMethod(), ObjectServiceGrpc.getNextMessageStreamMethod(), ProtoUtils.marshaller((Message)StreamRequest.getDefaultInstance()), ProtoUtils.marshaller((Message)StreamResponse.getDefaultInstance()), ProtoUtils.marshaller((Message)BrowserNextResponse.getDefaultInstance()), BrowserStream.Mode.IN_ORDER, log, this.sessionService).build();
    }
}

