/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.log;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.ElementsIntoSet;
import dagger.multibindings.IntoSet;
import io.deephaven.base.system.StandardStreamReceiver;
import io.deephaven.base.system.StandardStreamState;
import io.deephaven.base.system.StreamToPrintStreams;
import io.deephaven.internal.log.InitSink;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.log.LogSink;
import io.deephaven.io.logger.LogBuffer;
import io.deephaven.io.logger.LogBufferGlobal;
import io.deephaven.io.logger.StreamToLogBuffer;
import java.io.PrintStream;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;

@Module
public interface LogModule {
    @Provides
    public static LogBuffer providesLogBuffer() {
        return (LogBuffer)LogBufferGlobal.getInstance().orElseThrow(() -> new RuntimeException("No global LogBuffer found"));
    }

    @Provides
    public static LogSink providesLogSink() {
        return LoggerFactory.getLogger(LogModule.class).getSink();
    }

    @Provides
    @ElementsIntoSet
    public static Set<InitSink> providesLoggerSinkSetups() {
        return StreamSupport.stream(ServiceLoader.load(InitSink.class).spliterator(), false).collect(Collectors.toSet());
    }

    @Provides
    @Singleton
    public static StreamToLogBuffer providesStreamToLogBuffer(LogBuffer logBuffer) {
        boolean toStdout = Boolean.parseBoolean(System.getProperty("stdout.toLogBuffer", "true"));
        boolean toStderr = Boolean.parseBoolean(System.getProperty("stderr.toLogBuffer", "true"));
        return new StreamToLogBuffer(logBuffer, toStdout, toStderr, 256, 524288);
    }

    @Provides
    public static StreamToPrintStreams providesStreamToReal(@Nullable @Named(value="out") PrintStream out, @Nullable @Named(value="err") PrintStream err) {
        boolean skipStdout = Boolean.getBoolean("stdout.skipReal");
        boolean skipStderr = Boolean.getBoolean("stderr.skipReal");
        return new StreamToPrintStreams(skipStdout ? null : out, skipStderr ? null : err);
    }

    @Provides
    @Singleton
    public static StandardStreamState providesStandardStreamState(Set<StandardStreamReceiver> receivers) {
        return new StandardStreamState(receivers);
    }

    @Binds
    @IntoSet
    public StandardStreamReceiver bindsStreamToReal(StreamToPrintStreams var1);

    @Binds
    @IntoSet
    public StandardStreamReceiver bindsStreamToLogBufferInstance(StreamToLogBuffer var1);
}

