/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.log;

import io.deephaven.base.system.StandardStreamState;
import io.deephaven.engine.table.impl.util.AsyncClientErrorNotifier;
import io.deephaven.internal.log.InitSink;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.log.LogSink;
import io.deephaven.io.logger.LogBuffer;
import io.deephaven.io.logger.Logger;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class LogInit {
    private static final Logger log = LoggerFactory.getLogger(LogInit.class);
    private final StandardStreamState standardStreamState;
    private final LogBuffer logBuffer;
    private final LogSink logSink;
    private final Set<InitSink> sinkInits;

    @Inject
    public LogInit(StandardStreamState standardStreamState, LogBuffer logBuffer, LogSink logSink, Set<InitSink> sinkInits) {
        this.standardStreamState = standardStreamState;
        this.logBuffer = logBuffer;
        this.logSink = logSink;
        this.sinkInits = sinkInits;
    }

    @Inject
    public void run() {
        this.checkLogSinkIsSingleton();
        this.standardStreamState.setupRedirection();
        this.configureLoggerSink();
        Logger errLog = LoggerFactory.getLogger(AsyncClientErrorNotifier.class);
        AsyncClientErrorNotifier.setReporter(err -> errLog.error().append((CharSequence)"Error in table update: ").append(err).endl());
    }

    private void configureLoggerSink() {
        for (InitSink init : this.sinkInits) {
            init.accept(this.logSink, this.logBuffer);
        }
    }

    private void checkLogSinkIsSingleton() {
        if (log.getSink() != this.logSink) {
            throw new RuntimeException(String.format("Logger impl %s does not work with the current implementation.", log.getClass().getName()));
        }
    }
}

