/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.hierarchicaltable;

import io.deephaven.api.ColumnName;
import io.deephaven.engine.liveness.LivenessArtifact;
import io.deephaven.engine.liveness.LivenessReferent;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.hierarchical.HierarchicalTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HierarchicalTableView
extends LivenessArtifact {
    private final HierarchicalTable<?> hierarchicalTable;
    private final HierarchicalTable.SnapshotState snapshotState;
    private final Table keyTable;
    private final ColumnName keyTableActionColumn;

    private HierarchicalTableView(@NotNull HierarchicalTable<?> hierarchicalTable, @NotNull HierarchicalTable.SnapshotState snapshotState, @NotNull Table keyTable, @Nullable ColumnName keyTableActionColumn) {
        this.hierarchicalTable = hierarchicalTable;
        this.snapshotState = snapshotState;
        this.keyTable = keyTable;
        this.keyTableActionColumn = keyTableActionColumn;
        if (keyTable.isRefreshing()) {
            this.manage((LivenessReferent)keyTable);
        }
        if (hierarchicalTable.getSource().isRefreshing()) {
            this.manage((LivenessReferent)snapshotState);
        }
    }

    public HierarchicalTable<?> getHierarchicalTable() {
        return this.hierarchicalTable;
    }

    public HierarchicalTable.SnapshotState getSnapshotState() {
        return this.snapshotState;
    }

    public Table getKeyTable() {
        return this.keyTable;
    }

    public ColumnName getKeyTableActionColumn() {
        return this.keyTableActionColumn;
    }

    public static HierarchicalTableView makeFromHierarchicalTable(@NotNull HierarchicalTable<?> hierarchicalTable, @NotNull Table keyTable, @Nullable ColumnName keyTableActionColumn) {
        return new HierarchicalTableView(hierarchicalTable, hierarchicalTable.makeSnapshotState(), keyTable, keyTableActionColumn);
    }

    public static HierarchicalTableView makeFromHierarchicalTable(@NotNull HierarchicalTable<?> hierarchicalTable) {
        return new HierarchicalTableView(hierarchicalTable, hierarchicalTable.makeSnapshotState(), hierarchicalTable.getEmptyExpansionsTable(), null);
    }

    public static HierarchicalTableView makeFromExistingView(@NotNull HierarchicalTableView existingView, @NotNull Table keyTable, @Nullable ColumnName keyTableActionColumn) {
        return new HierarchicalTableView(existingView.hierarchicalTable, existingView.snapshotState, keyTable, keyTableActionColumn);
    }

    public static HierarchicalTableView makeFromExistingView(@NotNull HierarchicalTableView existingView) {
        return new HierarchicalTableView(existingView.hierarchicalTable, existingView.snapshotState, existingView.hierarchicalTable.getEmptyExpansionsTable(), null);
    }
}

