/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.hierarchicaltable;

import com.google.protobuf.Message;
import com.google.rpc.Code;
import io.deephaven.api.ColumnName;
import io.deephaven.api.Selectable;
import io.deephaven.api.SortColumn;
import io.deephaven.api.Strings;
import io.deephaven.api.filter.Filter;
import io.deephaven.auth.codegen.impl.HierarchicalTableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.hierarchical.HierarchicalTable;
import io.deephaven.engine.table.hierarchical.RollupTable;
import io.deephaven.engine.table.hierarchical.TreeTable;
import io.deephaven.engine.table.impl.BaseGridAttributes;
import io.deephaven.engine.table.impl.hierarchical.RollupTableImpl;
import io.deephaven.engine.table.impl.perf.QueryPerformanceNugget;
import io.deephaven.engine.table.impl.perf.QueryPerformanceRecorder;
import io.deephaven.engine.table.impl.select.SelectColumn;
import io.deephaven.engine.table.impl.select.WhereFilter;
import io.deephaven.engine.validation.ColumnExpressionValidator;
import io.deephaven.extensions.barrage.util.ExportUtil;
import io.deephaven.extensions.barrage.util.GrpcUtil;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.backplane.grpc.Condition;
import io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse;
import io.deephaven.proto.backplane.grpc.HierarchicalTableApplyRequest;
import io.deephaven.proto.backplane.grpc.HierarchicalTableApplyResponse;
import io.deephaven.proto.backplane.grpc.HierarchicalTableServiceGrpc;
import io.deephaven.proto.backplane.grpc.HierarchicalTableSourceExportRequest;
import io.deephaven.proto.backplane.grpc.HierarchicalTableViewRequest;
import io.deephaven.proto.backplane.grpc.HierarchicalTableViewResponse;
import io.deephaven.proto.backplane.grpc.RollupNodeType;
import io.deephaven.proto.backplane.grpc.RollupRequest;
import io.deephaven.proto.backplane.grpc.RollupResponse;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.backplane.grpc.TreeRequest;
import io.deephaven.proto.backplane.grpc.TreeResponse;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.auth.AuthorizationProvider;
import io.deephaven.server.grpc.Common;
import io.deephaven.server.grpc.GrpcErrorHelper;
import io.deephaven.server.hierarchicaltable.HierarchicalTableGrpcHelper;
import io.deephaven.server.hierarchicaltable.HierarchicalTableView;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.session.TicketResolver;
import io.deephaven.server.session.TicketRouter;
import io.deephaven.server.table.ops.AggregationAdapter;
import io.deephaven.server.table.ops.FilterTableGrpcImpl;
import io.deephaven.server.table.ops.filter.FilterFactory;
import io.deephaven.util.SafeCloseable;
import io.grpc.stub.StreamObserver;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HierarchicalTableServiceGrpcImpl
extends HierarchicalTableServiceGrpc.HierarchicalTableServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(HierarchicalTableServiceGrpcImpl.class);
    private final TicketRouter ticketRouter;
    private final SessionService sessionService;
    private final HierarchicalTableServiceContextualAuthWiring authWiring;
    private final TicketResolver.Authorization authTransformation;
    @NotNull
    private final ColumnExpressionValidator columnExpressionValidator;

    @Inject
    public HierarchicalTableServiceGrpcImpl(@NotNull TicketRouter ticketRouter, @NotNull SessionService sessionService, @NotNull AuthorizationProvider authorizationProvider, @NotNull ColumnExpressionValidator columnExpressionValidator) {
        this.ticketRouter = ticketRouter;
        this.sessionService = sessionService;
        this.authWiring = authorizationProvider.getHierarchicalTableServiceContextualAuthWiring();
        this.authTransformation = authorizationProvider.getTicketResolverAuthorization();
        this.columnExpressionValidator = columnExpressionValidator;
    }

    public void rollup(@NotNull RollupRequest request, @NotNull StreamObserver<RollupResponse> responseObserver) {
        HierarchicalTableServiceGrpcImpl.validate(request);
        SessionState session = this.sessionService.getCurrentSession();
        String description = "HierarchicalTableService#rollup(table=" + this.ticketRouter.getLogNameFor(request.getSourceTableId(), "sourceTableId") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject sourceTableExport = this.ticketRouter.resolve(session, request.getSourceTableId(), "sourceTableId");
            session.newExport(request.getResultRollupTableId(), "resultRollupTableId").queryPerformanceRecorder(queryPerformanceRecorder).require(sourceTableExport).onError(responseObserver).onSuccess(ignoredResult -> GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)RollupResponse.getDefaultInstance())).submit(() -> {
                Table sourceTable = (Table)sourceTableExport.get();
                this.authWiring.checkPermissionRollup(session.getAuthContext(), request, List.of(sourceTable));
                Collection aggregations = request.getAggregationsList().stream().map(AggregationAdapter::adapt).collect(Collectors.toList());
                boolean includeConstituents = request.getIncludeConstituents();
                Collection groupByColumns = request.getGroupByColumnsList().stream().map(ColumnName::of).collect(Collectors.toList());
                RollupTable result = sourceTable.rollup(aggregations, includeConstituents, groupByColumns);
                return result;
            });
        }
    }

    private static void validate(@NotNull RollupRequest request) {
        GrpcErrorHelper.checkHasField((Message)request, 1);
        GrpcErrorHelper.checkHasField((Message)request, 2);
        GrpcErrorHelper.checkHasNoUnknownFields((Message)request);
        Common.validate(request.getResultRollupTableId());
        Common.validate(request.getSourceTableId());
        request.getAggregationsList().forEach(AggregationAdapter::validate);
    }

    public void tree(@NotNull TreeRequest request, @NotNull StreamObserver<TreeResponse> responseObserver) {
        HierarchicalTableServiceGrpcImpl.validate(request);
        SessionState session = this.sessionService.getCurrentSession();
        String description = "HierarchicalTableService#tree(table=" + this.ticketRouter.getLogNameFor(request.getSourceTableId(), "sourceTableId") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject sourceTableExport = this.ticketRouter.resolve(session, request.getSourceTableId(), "sourceTableId");
            session.newExport(request.getResultTreeTableId(), "resultTreeTableId").queryPerformanceRecorder(queryPerformanceRecorder).require(sourceTableExport).onError(responseObserver).onSuccess(ignoredResult -> GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)TreeResponse.getDefaultInstance())).submit(() -> {
                Table sourceTable = (Table)sourceTableExport.get();
                this.authWiring.checkPermissionTree(session.getAuthContext(), request, List.of(sourceTable));
                ColumnName identifierColumn = ColumnName.of((String)request.getIdentifierColumn());
                ColumnName parentIdentifierColumn = ColumnName.of((String)request.getParentIdentifierColumn());
                Table sourceTableToUse = request.getPromoteOrphans() ? TreeTable.promoteOrphans((Table)sourceTable, (String)identifierColumn.name(), (String)parentIdentifierColumn.name()) : sourceTable;
                TreeTable result = sourceTableToUse.tree(identifierColumn.name(), parentIdentifierColumn.name());
                return result;
            });
        }
    }

    private static void validate(@NotNull TreeRequest request) {
        GrpcErrorHelper.checkHasField((Message)request, 1);
        GrpcErrorHelper.checkHasField((Message)request, 2);
        GrpcErrorHelper.checkHasField((Message)request, 3);
        GrpcErrorHelper.checkHasField((Message)request, 4);
        GrpcErrorHelper.checkHasNoUnknownFields((Message)request);
        Common.validate(request.getResultTreeTableId());
        Common.validate(request.getSourceTableId());
    }

    public void apply(@NotNull HierarchicalTableApplyRequest request, @NotNull StreamObserver<HierarchicalTableApplyResponse> responseObserver) {
        HierarchicalTableServiceGrpcImpl.validate(request);
        SessionState session = this.sessionService.getCurrentSession();
        String description = "HierarchicalTableService#apply(table=" + this.ticketRouter.getLogNameFor(request.getInputHierarchicalTableId(), "inputHierarchicalTableId") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject inputHierarchicalTableExport = this.ticketRouter.resolve(session, request.getInputHierarchicalTableId(), "inputHierarchicalTableId");
            session.newExport(request.getResultHierarchicalTableId(), "resultHierarchicalTableId").queryPerformanceRecorder(queryPerformanceRecorder).require(inputHierarchicalTableExport).onError(responseObserver).onSuccess(ignoredResult -> GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)HierarchicalTableApplyResponse.getDefaultInstance())).submit(() -> {
                TreeTable result;
                HierarchicalTable inputHierarchicalTable = (HierarchicalTable)inputHierarchicalTableExport.get();
                this.authWiring.checkPermissionApply(session.getAuthContext(), request, List.of(inputHierarchicalTable.getSource()));
                if (request.getFiltersCount() == 0 && request.getSortsCount() == 0 && request.getUpdateViewsCount() == 0 && request.getFormatViewsCount() == 0) {
                    throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"No operations specified");
                }
                List<Condition> finishedConditions = request.getFiltersCount() == 0 ? null : FilterTableGrpcImpl.finishConditions(request.getFiltersList());
                Collection<SortColumn> translatedSorts = HierarchicalTableServiceGrpcImpl.translateAndValidateSorts(request, (BaseGridAttributes)inputHierarchicalTable);
                if (inputHierarchicalTable instanceof RollupTable) {
                    RollupTable.NodeOperationsRecorder constituentViews;
                    Collection<UpdateViewRequest> translatedUpdateViews = this.translateAndValidateUpdateViews(request, inputHierarchicalTable);
                    Collection<UpdateViewRequest> translatedFormatViews = this.translateAndValidateFormatViews(request, inputHierarchicalTable);
                    RollupTable rollupTable = (RollupTable)inputHierarchicalTable;
                    TableDefinition nodeDefinition = rollupTable.getNodeDefinition(RollupTable.NodeType.Aggregated);
                    if (translatedUpdateViews != null) {
                        Collection aggregatedUpdateViews = translatedUpdateViews.stream().filter(uvr -> uvr.nodeType == RollupTable.NodeType.Aggregated).map(uvr -> uvr.columnSpec).collect(Collectors.toList());
                        RollupTable.NodeOperationsRecorder aggregatedViews = (RollupTable.NodeOperationsRecorder)rollupTable.makeNodeOperationsRecorder(RollupTable.NodeType.Aggregated).updateView(aggregatedUpdateViews);
                        if (rollupTable.includesConstituents()) {
                            Collection constituentUpdateViews = translatedUpdateViews.stream().filter(uvr -> uvr.nodeType == RollupTable.NodeType.Constituent).map(uvr -> uvr.columnSpec).collect(Collectors.toList());
                            constituentViews = (RollupTable.NodeOperationsRecorder)rollupTable.makeNodeOperationsRecorder(RollupTable.NodeType.Constituent).updateView(constituentUpdateViews);
                            rollupTable = rollupTable.withNodeOperations(new RollupTable.NodeOperationsRecorder[]{aggregatedViews, constituentViews});
                        } else {
                            rollupTable = rollupTable.withNodeOperations(new RollupTable.NodeOperationsRecorder[]{aggregatedViews});
                        }
                    }
                    if (translatedFormatViews != null) {
                        String[] aggregatedFormatViews = (String[])translatedFormatViews.stream().filter(uvr -> uvr.nodeType == RollupTable.NodeType.Aggregated).map(uvr -> Strings.of((Selectable)uvr.columnSpec)).toArray(String[]::new);
                        RollupTable.NodeOperationsRecorder aggregatedFormats = (RollupTable.NodeOperationsRecorder)rollupTable.makeNodeOperationsRecorder(RollupTable.NodeType.Aggregated).formatColumns(aggregatedFormatViews);
                        if (rollupTable.includesConstituents()) {
                            String[] constituentFormatViews = (String[])translatedFormatViews.stream().filter(uvr -> uvr.nodeType == RollupTable.NodeType.Constituent).map(uvr -> Strings.of((Selectable)uvr.columnSpec)).toArray(String[]::new);
                            constituentViews = (RollupTable.NodeOperationsRecorder)rollupTable.makeNodeOperationsRecorder(RollupTable.NodeType.Constituent).formatColumns(constituentFormatViews);
                            rollupTable = rollupTable.withNodeOperations(new RollupTable.NodeOperationsRecorder[]{aggregatedFormats, constituentViews});
                        } else {
                            rollupTable = rollupTable.withNodeOperations(new RollupTable.NodeOperationsRecorder[]{aggregatedFormats});
                        }
                    }
                    if (finishedConditions != null) {
                        List<WhereFilter> filters = HierarchicalTableServiceGrpcImpl.makeWhereFilters(finishedConditions, nodeDefinition);
                        RollupTableImpl.initializeAndValidateFilters((Table)rollupTable.getSource(), (Collection)rollupTable.getAggregations(), filters, message -> Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)message));
                        rollupTable = rollupTable.withFilter(Filter.and(filters));
                    }
                    if (translatedSorts != null) {
                        RollupTable.NodeOperationsRecorder aggregatedSorts = rollupTable.makeNodeOperationsRecorder(RollupTable.NodeType.Aggregated);
                        aggregatedSorts = (RollupTable.NodeOperationsRecorder)aggregatedSorts.sort(translatedSorts);
                        if (rollupTable.includesConstituents()) {
                            RollupTable.NodeOperationsRecorder constituentSorts = rollupTable.translateAggregatedNodeOperationsForConstituentNodes(aggregatedSorts);
                            rollupTable = rollupTable.withNodeOperations(new RollupTable.NodeOperationsRecorder[]{aggregatedSorts, constituentSorts});
                        } else {
                            rollupTable = rollupTable.withNodeOperations(new RollupTable.NodeOperationsRecorder[]{aggregatedSorts});
                        }
                    }
                    result = rollupTable;
                } else if (inputHierarchicalTable instanceof TreeTable) {
                    TreeTable treeTable = (TreeTable)inputHierarchicalTable;
                    TableDefinition nodeDefinition = treeTable.getNodeDefinition();
                    if (finishedConditions != null) {
                        treeTable = treeTable.withFilter(Filter.and(HierarchicalTableServiceGrpcImpl.makeWhereFilters(finishedConditions, nodeDefinition)));
                    }
                    if (translatedSorts != null) {
                        TreeTable.NodeOperationsRecorder treeSorts = treeTable.makeNodeOperationsRecorder();
                        treeSorts = (TreeTable.NodeOperationsRecorder)treeSorts.sort(translatedSorts);
                        treeTable = treeTable.withNodeOperations(treeSorts);
                    }
                    result = treeTable;
                } else {
                    throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Input is not a supported HierarchicalTable type");
                }
                return result;
            });
        }
    }

    private static void validate(@NotNull HierarchicalTableApplyRequest request) {
        GrpcErrorHelper.checkHasField((Message)request, 1);
        GrpcErrorHelper.checkHasField((Message)request, 2);
        GrpcErrorHelper.checkHasNoUnknownFields((Message)request);
        Common.validate(request.getResultHierarchicalTableId());
        Common.validate(request.getInputHierarchicalTableId());
    }

    @NotNull
    private static List<WhereFilter> makeWhereFilters(@NotNull Collection<Condition> finishedConditions, @NotNull TableDefinition nodeDefinition) {
        return finishedConditions.stream().map(condition -> FilterFactory.makeFilter(nodeDefinition, condition)).collect(Collectors.toList());
    }

    @Nullable
    private static Collection<SortColumn> translateAndValidateSorts(@NotNull HierarchicalTableApplyRequest request, @NotNull BaseGridAttributes<?, ?> inputHierarchicalTable) {
        if (request.getSortsCount() == 0) {
            return null;
        }
        return HierarchicalTableGrpcHelper.translateAndValidateSorts(request.getSortsList(), () -> inputHierarchicalTable.getSortableColumns());
    }

    private static RollupTable.NodeType translateNodeType(RollupNodeType nodeType) {
        switch (nodeType) {
            case AGGREGATED: {
                return RollupTable.NodeType.Aggregated;
            }
            case CONSTITUENT: {
                return RollupTable.NodeType.Constituent;
            }
        }
        throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Unsupported or unknown node type: " + String.valueOf(nodeType)));
    }

    @Nullable
    private Collection<UpdateViewRequest> translateAndValidateUpdateViews(@NotNull HierarchicalTableApplyRequest request, @NotNull HierarchicalTable<?> inputHierarchicalTable) {
        if (request.getUpdateViewsCount() == 0) {
            return null;
        }
        Table source = inputHierarchicalTable.getSource();
        Selectable[] selectables = (Selectable[])request.getUpdateViewsList().stream().map(uvr -> AggregationAdapter.adapt(uvr.getColumnSpec())).toArray(Selectable[]::new);
        String[] columnSpecs = (String[])Arrays.asList(selectables).stream().map(Strings::of).toArray(String[]::new);
        SelectColumn[] expressions = SelectColumn.from((Selectable[])selectables);
        this.columnExpressionValidator.validateColumnExpressions(expressions, columnSpecs, source);
        return request.getUpdateViewsList().stream().map(uvr -> new UpdateViewRequest(AggregationAdapter.adapt(uvr.getColumnSpec()), HierarchicalTableServiceGrpcImpl.translateNodeType(uvr.getNodeType()))).collect(Collectors.toList());
    }

    @Nullable
    private Collection<UpdateViewRequest> translateAndValidateFormatViews(@NotNull HierarchicalTableApplyRequest request, @NotNull HierarchicalTable<?> inputHierarchicalTable) {
        if (request.getFormatViewsCount() == 0) {
            return null;
        }
        Table source = inputHierarchicalTable.getSource();
        Selectable[] selectables = (Selectable[])request.getUpdateViewsList().stream().map(uvr -> AggregationAdapter.adapt(uvr.getColumnSpec())).toArray(Selectable[]::new);
        String[] columnSpecs = (String[])Arrays.asList(selectables).stream().map(Strings::of).toArray(String[]::new);
        SelectColumn[] expressions = SelectColumn.from((Selectable[])selectables);
        this.columnExpressionValidator.validateColumnExpressions(expressions, columnSpecs, source);
        return request.getFormatViewsList().stream().map(uvr -> new UpdateViewRequest(AggregationAdapter.adapt(uvr.getColumnSpec()), HierarchicalTableServiceGrpcImpl.translateNodeType(uvr.getNodeType()))).collect(Collectors.toList());
    }

    public void view(@NotNull HierarchicalTableViewRequest request, @NotNull StreamObserver<HierarchicalTableViewResponse> responseObserver) {
        Ticket targetTicket;
        boolean usedExisting;
        HierarchicalTableServiceGrpcImpl.validate(request);
        SessionState session = this.sessionService.getCurrentSession();
        switch (request.getTargetCase()) {
            case HIERARCHICAL_TABLE_ID: {
                usedExisting = false;
                targetTicket = request.getHierarchicalTableId();
                break;
            }
            case EXISTING_VIEW_ID: {
                usedExisting = true;
                targetTicket = request.getExistingViewId();
                break;
            }
            default: {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"No target specified");
            }
        }
        String description = "HierarchicalTableService#view(table=" + this.ticketRouter.getLogNameFor(targetTicket, "targetTableId") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject keyTableExport;
            SessionState.ExportBuilder resultExportBuilder = session.newExport(request.getResultViewId(), "resultViewId");
            SessionState.ExportObject targetExport = this.ticketRouter.resolve(session, targetTicket, "targetTableId");
            if (request.hasExpansions()) {
                keyTableExport = this.ticketRouter.resolve(session, request.getExpansions().getKeyTableId(), "expansions.keyTableId");
                resultExportBuilder.require(targetExport, keyTableExport);
            } else {
                keyTableExport = null;
                resultExportBuilder.require(targetExport);
            }
            resultExportBuilder.queryPerformanceRecorder(queryPerformanceRecorder).onError(responseObserver).onSuccess(ignoredResult -> GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)HierarchicalTableViewResponse.getDefaultInstance())).submit(() -> {
                Table keyTable = keyTableExport == null ? null : (Table)keyTableExport.get();
                Object target = targetExport.get();
                HierarchicalTableView targetExistingView = usedExisting ? (HierarchicalTableView)((Object)((Object)target)) : null;
                HierarchicalTable targetHierarchicalTable = usedExisting ? targetExistingView.getHierarchicalTable() : (HierarchicalTable)target;
                this.authWiring.checkPermissionView(session.getAuthContext(), request, keyTable == null ? List.of(targetHierarchicalTable.getSource()) : List.of(keyTable, targetHierarchicalTable.getSource()));
                HierarchicalTableView result = usedExisting ? (keyTable != null ? HierarchicalTableView.makeFromExistingView(targetExistingView, keyTable, request.getExpansions().hasKeyTableActionColumn() ? ColumnName.of((String)request.getExpansions().getKeyTableActionColumn()) : null) : HierarchicalTableView.makeFromExistingView(targetExistingView)) : (keyTable != null ? HierarchicalTableView.makeFromHierarchicalTable(targetHierarchicalTable, keyTable, request.getExpansions().hasKeyTableActionColumn() ? ColumnName.of((String)request.getExpansions().getKeyTableActionColumn()) : null) : HierarchicalTableView.makeFromHierarchicalTable(targetHierarchicalTable));
                return result;
            });
        }
    }

    private static void validate(@NotNull HierarchicalTableViewRequest request) {
        GrpcErrorHelper.checkHasField((Message)request, 1);
        GrpcErrorHelper.checkHasOneOf((Message)request, "target");
        GrpcErrorHelper.checkHasNoUnknownFields((Message)request);
        switch (request.getTargetCase()) {
            case HIERARCHICAL_TABLE_ID: {
                Common.validate(request.getHierarchicalTableId());
                break;
            }
            case EXISTING_VIEW_ID: {
                Common.validate(request.getExistingViewId());
                break;
            }
            case TARGET_NOT_SET: {
                Assert.statementNeverExecuted((String)"No target specified, despite prior validation");
                break;
            }
            default: {
                throw Exceptions.statusRuntimeException((Code)Code.INTERNAL, (String)String.format("%s has unexpected target case %s", request.getDescriptorForType().getFullName(), request.getTargetCase()));
            }
        }
    }

    public void exportSource(@NotNull HierarchicalTableSourceExportRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        HierarchicalTableServiceGrpcImpl.validate(request);
        SessionState session = this.sessionService.getCurrentSession();
        String description = "HierarchicalTableService#exportSource(table=" + this.ticketRouter.getLogNameFor(request.getHierarchicalTableId(), "hierarchicalTableId") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject hierarchicalTableExport = this.ticketRouter.resolve(session, request.getHierarchicalTableId(), "hierarchicalTableId");
            session.newExport(request.getResultTableId(), "resultTableId").queryPerformanceRecorder(queryPerformanceRecorder).require(hierarchicalTableExport).onError(responseObserver).onSuccess(transformedResult -> GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)ExportUtil.buildTableCreationResponse((Ticket)request.getResultTableId(), (Table)transformedResult))).submit(() -> {
                HierarchicalTable hierarchicalTable = (HierarchicalTable)hierarchicalTableExport.get();
                Table result = hierarchicalTable.getSource();
                this.authWiring.checkPermissionExportSource(session.getAuthContext(), request, List.of(result));
                return result;
            });
        }
    }

    private static void validate(@NotNull HierarchicalTableSourceExportRequest request) {
        GrpcErrorHelper.checkHasField((Message)request, 1);
        GrpcErrorHelper.checkHasField((Message)request, 2);
        GrpcErrorHelper.checkHasNoUnknownFields((Message)request);
        Common.validate(request.getResultTableId());
        Common.validate(request.getHierarchicalTableId());
    }

    private static class UpdateViewRequest {
        final Selectable columnSpec;
        final RollupTable.NodeType nodeType;

        UpdateViewRequest(Selectable columnSpec, RollupTable.NodeType nodeType) {
            this.columnSpec = columnSpec;
            this.nodeType = nodeType;
        }
    }
}

