/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.hierarchicaltable;

import com.google.rpc.Code;
import io.deephaven.api.ColumnName;
import io.deephaven.api.SortColumn;
import io.deephaven.engine.table.impl.AbsoluteSortColumnConventions;
import io.deephaven.proto.backplane.grpc.SortDescriptor;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.util.annotations.InternalUseOnly;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalUseOnly
public class HierarchicalTableGrpcHelper {
    @Nullable
    public static Collection<SortColumn> translateAndValidateSorts(@NotNull List<SortDescriptor> sortsList, @NotNull Supplier<Set<String>> sortableColumnsSupplier) {
        if (sortsList.isEmpty()) {
            return null;
        }
        Collection translatedSorts = sortsList.stream().map(HierarchicalTableGrpcHelper::translateSort).collect(Collectors.toList());
        Set<String> sortableColumnNames = sortableColumnsSupplier.get();
        if (sortableColumnNames != null) {
            if (sortableColumnNames.isEmpty()) {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Sorting is not supported on this hierarchical table");
            }
            Collection unavailableSortColumnNames = translatedSorts.stream().map(sc -> AbsoluteSortColumnConventions.stripAbsoluteColumnName((String)sc.column().name())).filter(scn -> !sortableColumnNames.contains(scn)).collect(Collectors.toList());
            if (!unavailableSortColumnNames.isEmpty()) {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Sorting attempted on restricted column(s): " + unavailableSortColumnNames.stream().collect(Collectors.joining(", ", "[", "]")) + ", available column(s) for sorting are: " + sortableColumnNames.stream().collect(Collectors.joining(", ", "[", "]"))));
            }
        }
        return translatedSorts;
    }

    private static SortColumn translateSort(@NotNull SortDescriptor sortDescriptor) {
        switch (sortDescriptor.getDirection()) {
            case DESCENDING: {
                return SortColumn.desc((ColumnName)ColumnName.of((String)(sortDescriptor.getIsAbsolute() ? AbsoluteSortColumnConventions.baseColumnNameToAbsoluteName((String)sortDescriptor.getColumnName()) : sortDescriptor.getColumnName())));
            }
            case ASCENDING: {
                return SortColumn.asc((ColumnName)ColumnName.of((String)(sortDescriptor.getIsAbsolute() ? AbsoluteSortColumnConventions.baseColumnNameToAbsoluteName((String)sortDescriptor.getColumnName()) : sortDescriptor.getColumnName())));
            }
        }
        throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Unsupported or unknown sort direction: " + String.valueOf(sortDescriptor.getDirection())));
    }
}

