/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.grpc;

import com.google.protobuf.Message;
import com.google.rpc.Code;
import io.deephaven.proto.backplane.grpc.TableReference;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.grpc.GrpcErrorHelper;

public class Common {
    public static void validate(Ticket ticket) {
        GrpcErrorHelper.checkHasNoUnknownFields((Message)ticket);
        if (ticket.getTicket().isEmpty()) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Ticket is empty");
        }
    }

    public static void validate(TableReference tableReference) {
        GrpcErrorHelper.checkHasOneOf((Message)tableReference, "ref");
        GrpcErrorHelper.checkHasNoUnknownFields((Message)tableReference);
        TableReference.RefCase ref = tableReference.getRefCase();
        switch (ref) {
            case TICKET: {
                Common.validate(tableReference.getTicket());
                break;
            }
            case BATCH_OFFSET: {
                break;
            }
            default: {
                throw Exceptions.statusRuntimeException((Code)Code.INTERNAL, (String)String.format("Server missing TableReference type %s", ref));
            }
        }
    }
}

