/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.console.python;

import io.deephaven.configuration.Configuration;
import io.deephaven.engine.util.PythonEvaluatorJpy;
import io.deephaven.util.thread.ThreadInitializationFactory;
import java.io.Closeable;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jpy.PyLib;
import org.jpy.PyModule;
import org.jpy.PyObject;

public class DebuggingInitializer
implements ThreadInitializationFactory {
    private final Provider<PythonEvaluatorJpy> pythonProvider;

    @Inject
    public DebuggingInitializer(Provider<PythonEvaluatorJpy> pythonProvider) {
        this.pythonProvider = pythonProvider;
    }

    public Runnable createInitializer(Runnable runnable) {
        if (!"python".equals(Configuration.getInstance().getStringWithDefault("deephaven.console.type", null))) {
            return runnable;
        }
        this.pythonProvider.get();
        return () -> {
            DeephavenModule py_deephaven = (DeephavenModule)PyModule.importModule((String)"deephaven_internal.java_threads").createProxy(PyLib.CallableKind.FUNCTION, new Class[]{DeephavenModule.class});
            PyObject runnableResult = py_deephaven.create_thread_entry(Thread.currentThread().getName());
            runnableResult.call("__call__", new Object[]{runnable});
        };
    }

    static interface DeephavenModule
    extends Closeable {
        public PyObject create_thread_entry(String var1);
    }
}

