/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.console.completer;

import com.google.rpc.Code;
import io.deephaven.engine.util.ScriptSession;
import io.deephaven.extensions.barrage.util.GrpcUtil;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.lang.completion.ChunkerCompleter;
import io.deephaven.lang.parse.CompletionParser;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.backplane.script.grpc.AutoCompleteRequest;
import io.deephaven.proto.backplane.script.grpc.AutoCompleteResponse;
import io.deephaven.proto.backplane.script.grpc.ChangeDocumentRequest;
import io.deephaven.proto.backplane.script.grpc.CloseDocumentRequest;
import io.deephaven.proto.backplane.script.grpc.CompletionItem;
import io.deephaven.proto.backplane.script.grpc.DocumentRange;
import io.deephaven.proto.backplane.script.grpc.GetCompletionItemsRequest;
import io.deephaven.proto.backplane.script.grpc.GetCompletionItemsResponse;
import io.deephaven.proto.backplane.script.grpc.GetHoverRequest;
import io.deephaven.proto.backplane.script.grpc.GetHoverResponse;
import io.deephaven.proto.backplane.script.grpc.GetPullDiagnosticResponse;
import io.deephaven.proto.backplane.script.grpc.GetSignatureHelpRequest;
import io.deephaven.proto.backplane.script.grpc.GetSignatureHelpResponse;
import io.deephaven.proto.backplane.script.grpc.MarkupContent;
import io.deephaven.proto.backplane.script.grpc.ParameterInformation;
import io.deephaven.proto.backplane.script.grpc.Position;
import io.deephaven.proto.backplane.script.grpc.SignatureInformation;
import io.deephaven.proto.backplane.script.grpc.TextDocumentItem;
import io.deephaven.proto.backplane.script.grpc.TextEdit;
import io.deephaven.proto.backplane.script.grpc.VersionedTextDocumentIdentifier;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.console.ConsoleServiceGrpcImpl;
import io.deephaven.server.session.SessionCloseableObserver;
import io.deephaven.server.session.SessionState;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import org.jpy.PyObject;

public class PythonAutoCompleteObserver
extends SessionCloseableObserver<AutoCompleteResponse>
implements StreamObserver<AutoCompleteRequest> {
    private static final Logger log = LoggerFactory.getLogger(PythonAutoCompleteObserver.class);
    private static final long HUNDRED_MS_IN_NS = 100000000L;
    private final Provider<ScriptSession> scriptSession;

    public PythonAutoCompleteObserver(StreamObserver<AutoCompleteResponse> responseObserver, Provider<ScriptSession> scriptSession, SessionState session) {
        super(session, responseObserver);
        this.scriptSession = scriptSession;
    }

    public void onNext(AutoCompleteRequest value) {
        switch (value.getRequestCase()) {
            case OPEN_DOCUMENT: {
                TextDocumentItem doc = value.getOpenDocument().getTextDocument();
                PyObject completer = (PyObject)((ScriptSession)this.scriptSession.get()).getQueryScope().readParamValue("jedi_settings");
                completer.callMethod("open_doc", new Object[]{doc.getText(), doc.getUri(), doc.getVersion()});
                break;
            }
            case CHANGE_DOCUMENT: {
                ChangeDocumentRequest request = value.getChangeDocument();
                VersionedTextDocumentIdentifier text = request.getTextDocument();
                PyObject completer = (PyObject)((ScriptSession)this.scriptSession.get()).getQueryScope().readParamValue("jedi_settings");
                String uri = text.getUri();
                int version = text.getVersion();
                String document = completer.callMethod("get_doc", new Object[]{text.getUri()}).getStringValue();
                List changes = request.getContentChangesList();
                document = CompletionParser.updateDocumentChanges((String)uri, (int)version, (String)document, (List)changes);
                if (document == null) {
                    return;
                }
                completer.callMethod("update_doc", new Object[]{document, uri, version});
                break;
            }
            case CLOSE_DOCUMENT: {
                PyObject completer = (PyObject)((ScriptSession)this.scriptSession.get()).getQueryScope().readParamValue("jedi_settings");
                CloseDocumentRequest request = value.getCloseDocument();
                completer.callMethod("close_doc", new Object[]{request.getTextDocument().getUri()});
                break;
            }
            case REQUEST_NOT_SET: {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Autocomplete command missing request");
            }
            default: {
                Ticket consoleId = value.hasConsoleId() ? value.getConsoleId() : value.getGetCompletionItems().getConsoleId();
                SessionState.ExportObject exportedConsole = this.session.getExport(consoleId, "consoleId");
                this.session.nonExport().require(exportedConsole).onError(this.responseObserver).submit(() -> this.handleAutocompleteRequest(value, exportedConsole, (StreamObserver<AutoCompleteResponse>)this.responseObserver));
            }
        }
    }

    private void handleAutocompleteRequest(AutoCompleteRequest request, SessionState.ExportObject<ScriptSession> exportedConsole, StreamObserver<AutoCompleteResponse> responseObserver) {
        block12: {
            int requestId = request.getRequestId() > 0 ? request.getRequestId() : request.getGetCompletionItems().getRequestId();
            try {
                ScriptSession scriptSession = exportedConsole.get();
                PyObject completer = (PyObject)scriptSession.getQueryScope().readParamValue("jedi_settings");
                boolean canJedi = completer.callMethod("is_enabled", new Object[0]).getBooleanValue();
                if (!canJedi) {
                    log.trace().append((CharSequence)"Ignoring completion request because jedi is disabled").endl();
                    GrpcUtil.safelyOnNext(responseObserver, (Object)AutoCompleteResponse.newBuilder().setSuccess(false).setRequestId(requestId).build());
                    return;
                }
                AutoCompleteResponse.Builder response = AutoCompleteResponse.newBuilder();
                switch (request.getRequestCase()) {
                    case GET_COMPLETION_ITEMS: {
                        response.setCompletionItems(this.getCompletionItems(request.getGetCompletionItems(), completer));
                        break;
                    }
                    case GET_SIGNATURE_HELP: {
                        response.setSignatures(this.getSignatureHelp(request.getGetSignatureHelp(), completer));
                        break;
                    }
                    case GET_HOVER: {
                        response.setHover(this.getHover(request.getGetHover(), completer));
                        break;
                    }
                    case GET_DIAGNOSTIC: {
                        response.setDiagnostic(GetPullDiagnosticResponse.getDefaultInstance());
                    }
                }
                GrpcUtil.safelyOnNext(responseObserver, (Object)response.setSuccess(true).setRequestId(requestId).build());
            }
            catch (Throwable exception) {
                if (ConsoleServiceGrpcImpl.QUIET_AUTOCOMPLETE_ERRORS) {
                    if (log.isTraceEnabled()) {
                        log.trace().append((CharSequence)"Exception occurred during autocomplete").append(exception).endl();
                    }
                } else {
                    log.error().append((CharSequence)"Exception occurred during autocomplete").append(exception).endl();
                }
                GrpcUtil.safelyOnNext(responseObserver, (Object)AutoCompleteResponse.newBuilder().setSuccess(false).setRequestId(requestId).build());
                if (!(exception instanceof Error)) break block12;
                throw exception;
            }
        }
    }

    private GetCompletionItemsResponse getCompletionItems(GetCompletionItemsRequest request, PyObject completer) {
        VersionedTextDocumentIdentifier doc = request.getTextDocument();
        Position pos = request.getPosition();
        PyObject results = completer.callMethod("do_completion", new Object[]{doc.getUri(), doc.getVersion(), pos.getLine() + 1, pos.getCharacter()});
        if (!results.isList()) {
            throw new UnsupportedOperationException("Expected list from jedi_settings.do_completion, got " + String.valueOf(results.call("repr", new Object[0])));
        }
        ArrayList<CompletionItem> finalItems = new ArrayList<CompletionItem>();
        for (PyObject result : results.asList()) {
            if (!result.isList()) {
                throw new UnsupportedOperationException("Expected list-of-lists from jedi_settings.do_completion, got bad result " + String.valueOf(result.call("repr", new Object[0])) + " from full results: " + String.valueOf(results.call("repr", new Object[0])));
            }
            List items = result.asList();
            String completionName = ((PyObject)items.get(0)).getStringValue();
            int start = ((PyObject)items.get(1)).getIntValue();
            CompletionItem.Builder item = CompletionItem.newBuilder();
            TextEdit.Builder textEdit = item.getTextEditBuilder();
            textEdit.setText(completionName);
            DocumentRange.Builder range = textEdit.getRangeBuilder();
            item.setStart(start);
            item.setLabel(completionName);
            item.setLength(completionName.length());
            item.setDetail(((PyObject)items.get(2)).getStringValue());
            item.setDocumentation(MarkupContent.newBuilder().setValue(((PyObject)items.get(3)).getStringValue()).setKind("plaintext").build());
            item.setKind(((PyObject)items.get(4)).getIntValue());
            range.getStartBuilder().setLine(pos.getLine()).setCharacter(start);
            range.getEndBuilder().setLine(pos.getLine()).setCharacter(pos.getCharacter());
            item.setInsertTextFormat(2);
            item.setSortText(ChunkerCompleter.sortable((int)finalItems.size()));
            finalItems.add(item.build());
        }
        return GetCompletionItemsResponse.newBuilder().setSuccess(true).setRequestId(request.getRequestId()).addAllItems(finalItems).build();
    }

    private GetSignatureHelpResponse getSignatureHelp(GetSignatureHelpRequest request, PyObject completer) {
        VersionedTextDocumentIdentifier doc = request.getTextDocument();
        Position pos = request.getPosition();
        PyObject results = completer.callMethod("do_signature_help", new Object[]{doc.getUri(), doc.getVersion(), pos.getLine() + 1, pos.getCharacter()});
        if (!results.isList()) {
            throw new UnsupportedOperationException("Expected list from jedi_settings.do_signature_help, got " + String.valueOf(results.call("repr", new Object[0])));
        }
        ArrayList<SignatureInformation> finalItems = new ArrayList<SignatureInformation>();
        for (PyObject result : results.asList()) {
            if (!result.isList()) {
                throw new UnsupportedOperationException("Expected list-of-lists from jedi_settings.do_signature_help, got bad result " + String.valueOf(result.call("repr", new Object[0])) + " from full results: " + String.valueOf(results.call("repr", new Object[0])));
            }
            List signature = result.asList();
            String label = ((PyObject)signature.get(0)).getStringValue();
            String docstring = ((PyObject)signature.get(1)).getStringValue();
            int activeParam = ((PyObject)signature.get(3)).getIntValue();
            SignatureInformation.Builder item = SignatureInformation.newBuilder();
            item.setLabel(label);
            item.setDocumentation(MarkupContent.newBuilder().setValue(docstring).setKind("markdown").build());
            item.setActiveParameter(activeParam);
            ((PyObject)signature.get(2)).asList().forEach(obj -> {
                List param = obj.asList();
                item.addParameters(ParameterInformation.newBuilder().setLabel(((PyObject)param.get(0)).getStringValue()).setDocumentation(MarkupContent.newBuilder().setValue(((PyObject)param.get(1)).getStringValue()).setKind("markdown").build()));
            });
            finalItems.add(item.build());
        }
        return GetSignatureHelpResponse.newBuilder().addAllSignatures(finalItems).build();
    }

    private GetHoverResponse getHover(GetHoverRequest request, PyObject completer) {
        VersionedTextDocumentIdentifier doc = request.getTextDocument();
        Position pos = request.getPosition();
        PyObject result = completer.callMethod("do_hover", new Object[]{doc.getUri(), doc.getVersion(), pos.getLine() + 1, pos.getCharacter()});
        if (!result.isString()) {
            throw new UnsupportedOperationException("Expected string from jedi_settings.do_hover, got " + String.valueOf(result.call("repr", new Object[0])));
        }
        return GetHoverResponse.newBuilder().setContents(MarkupContent.newBuilder().setValue(result.getStringValue()).setKind("markdown")).build();
    }

    private String toMillis(long totalNanos) {
        StringBuilder totalNano = new StringBuilder(Long.toString(totalNanos));
        while (totalNano.length() < 7) {
            totalNano.insert(0, "0");
        }
        int milliCutoff = totalNano.length() - 6;
        return totalNano.substring(0, milliCutoff) + "." + totalNano.substring(milliCutoff, Math.min(milliCutoff + 2, totalNano.length())) + "ms";
    }

    public void onError(Throwable t) {
    }

    public void onCompleted() {
        GrpcUtil.safelyComplete((StreamObserver)this.responseObserver);
    }
}

