/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.console.completer;

import com.google.rpc.Code;
import io.deephaven.engine.context.QueryScope;
import io.deephaven.engine.util.ScriptSession;
import io.deephaven.extensions.barrage.util.GrpcUtil;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.lang.completion.ChunkerCompleter;
import io.deephaven.lang.completion.CompletionLookups;
import io.deephaven.lang.completion.CustomCompletion;
import io.deephaven.lang.parse.CompletionParser;
import io.deephaven.lang.parse.LspTools;
import io.deephaven.lang.parse.ParsedDocument;
import io.deephaven.lang.shared.lsp.CompletionCancelled;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.backplane.script.grpc.AutoCompleteRequest;
import io.deephaven.proto.backplane.script.grpc.AutoCompleteResponse;
import io.deephaven.proto.backplane.script.grpc.ChangeDocumentRequest;
import io.deephaven.proto.backplane.script.grpc.CloseDocumentRequest;
import io.deephaven.proto.backplane.script.grpc.GetCompletionItemsRequest;
import io.deephaven.proto.backplane.script.grpc.GetCompletionItemsResponse;
import io.deephaven.proto.backplane.script.grpc.GetHoverResponse;
import io.deephaven.proto.backplane.script.grpc.GetPullDiagnosticResponse;
import io.deephaven.proto.backplane.script.grpc.GetSignatureHelpResponse;
import io.deephaven.proto.backplane.script.grpc.MarkupContent;
import io.deephaven.proto.backplane.script.grpc.Position;
import io.deephaven.proto.backplane.script.grpc.TextDocumentItem;
import io.deephaven.proto.backplane.script.grpc.VersionedTextDocumentIdentifier;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.console.ConsoleServiceGrpcImpl;
import io.deephaven.server.session.SessionCloseableObserver;
import io.deephaven.server.session.SessionState;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;

public class JavaAutoCompleteObserver
extends SessionCloseableObserver<AutoCompleteResponse>
implements StreamObserver<AutoCompleteRequest> {
    private static final Logger log = LoggerFactory.getLogger(JavaAutoCompleteObserver.class);
    private static final Map<SessionState, CompletionParser> parsers = Collections.synchronizedMap(new WeakHashMap());
    private final CompletionParser parser;
    private final Set<CustomCompletion.Factory> customCompletionFactory;

    private static CompletionParser ensureParserForSession(SessionState session) {
        return parsers.computeIfAbsent(session, s -> {
            CompletionParser parser = new CompletionParser();
            s.addOnCloseCallback(() -> {
                parsers.remove(s);
                parser.close();
            });
            return parser;
        });
    }

    public JavaAutoCompleteObserver(SessionState session, StreamObserver<AutoCompleteResponse> responseObserver, Set<CustomCompletion.Factory> customCompletionFactory) {
        super(session, responseObserver);
        this.parser = JavaAutoCompleteObserver.ensureParserForSession(session);
        this.customCompletionFactory = customCompletionFactory;
    }

    public void onNext(AutoCompleteRequest value) {
        switch (value.getRequestCase()) {
            case OPEN_DOCUMENT: {
                TextDocumentItem doc = value.getOpenDocument().getTextDocument();
                this.parser.open(doc.getText(), doc.getUri(), Integer.toString(doc.getVersion()));
                break;
            }
            case CHANGE_DOCUMENT: {
                ChangeDocumentRequest request = value.getChangeDocument();
                VersionedTextDocumentIdentifier text = request.getTextDocument();
                this.parser.update(text.getUri(), text.getVersion(), request.getContentChangesList());
                break;
            }
            case CLOSE_DOCUMENT: {
                CloseDocumentRequest request = value.getCloseDocument();
                this.parser.remove(request.getTextDocument().getUri());
                break;
            }
            case REQUEST_NOT_SET: {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Autocomplete command missing request");
            }
            default: {
                Ticket consoleId = value.hasConsoleId() ? value.getConsoleId() : value.getGetCompletionItems().getConsoleId();
                SessionState.ExportObject exportedConsole = this.session.getExport(consoleId, "consoleId");
                this.session.nonExport().require(exportedConsole).onError(this.responseObserver).submit(() -> this.handleAutocompleteRequest(value, exportedConsole, (StreamObserver<AutoCompleteResponse>)this.responseObserver));
            }
        }
    }

    private void handleAutocompleteRequest(AutoCompleteRequest request, SessionState.ExportObject<ScriptSession> exportedConsole, StreamObserver<AutoCompleteResponse> responseObserver) {
        int requestId = request.getRequestId() > 0 ? request.getRequestId() : request.getGetCompletionItems().getRequestId();
        try {
            AutoCompleteResponse.Builder response = AutoCompleteResponse.newBuilder();
            switch (request.getRequestCase()) {
                case GET_COMPLETION_ITEMS: {
                    response.setCompletionItems(this.getCompletionItems(request.getGetCompletionItems(), exportedConsole, this.parser, responseObserver));
                    break;
                }
                case GET_SIGNATURE_HELP: {
                    response.setSignatures(GetSignatureHelpResponse.getDefaultInstance());
                    break;
                }
                case GET_HOVER: {
                    response.setHover(GetHoverResponse.newBuilder().setContents(MarkupContent.getDefaultInstance()).build());
                    break;
                }
                case GET_DIAGNOSTIC: {
                    response.setDiagnostic(GetPullDiagnosticResponse.getDefaultInstance());
                }
            }
            GrpcUtil.safelyOnNext(responseObserver, (Object)response.setSuccess(true).setRequestId(requestId).build());
        }
        catch (CompletionCancelled exception) {
            if (log.isTraceEnabled()) {
                log.trace().append((CharSequence)"Completion canceled").append((Throwable)exception).endl();
            }
            GrpcUtil.safelyOnNext(responseObserver, (Object)AutoCompleteResponse.newBuilder().setSuccess(false).setRequestId(request.getRequestId()).build());
        }
        catch (Exception exception) {
            if (ConsoleServiceGrpcImpl.QUIET_AUTOCOMPLETE_ERRORS) {
                if (log.isTraceEnabled()) {
                    log.trace().append((CharSequence)"Exception occurred during autocomplete").append((Throwable)exception).endl();
                }
            } else {
                log.error().append((CharSequence)"Exception occurred during autocomplete").append((Throwable)exception).endl();
            }
            GrpcUtil.safelyOnNext(responseObserver, (Object)AutoCompleteResponse.newBuilder().setSuccess(false).setRequestId(request.getRequestId()).build());
        }
    }

    private GetCompletionItemsResponse getCompletionItems(GetCompletionItemsRequest request, SessionState.ExportObject<ScriptSession> exportedConsole, CompletionParser parser, StreamObserver<AutoCompleteResponse> responseObserver) {
        ScriptSession scriptSession = exportedConsole.get();
        QueryScope vars = scriptSession.getQueryScope();
        VersionedTextDocumentIdentifier doc = request.getTextDocument();
        CompletionLookups h = CompletionLookups.preload((ScriptSession)scriptSession, this.customCompletionFactory);
        ChunkerCompleter completer = new ChunkerCompleter(log, vars, h);
        ParsedDocument parsed = parser.finish(doc.getUri());
        int offset = LspTools.getOffsetFromPosition((String)parsed.getSource(), (Position)request.getPosition());
        Collection results = completer.runCompletion(parsed, request.getPosition(), offset);
        return GetCompletionItemsResponse.newBuilder().setSuccess(true).setRequestId(request.getRequestId()).addAllItems((Iterable)results.stream().map(item -> item.setInsertTextFormat(2).build()).collect(Collectors.toSet())).build();
    }

    public void onError(Throwable t) {
    }

    public void onCompleted() {
        GrpcUtil.safelyComplete((StreamObserver)this.responseObserver);
    }
}

