/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.console;

import com.google.protobuf.ByteStringAccess;
import com.google.rpc.Code;
import io.deephaven.base.string.EncodingInfo;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.context.QueryScope;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.flight.util.TicketRouterHelper;
import io.deephaven.proto.util.ByteHelper;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.proto.util.ScopeTicketHelper;
import io.deephaven.server.auth.AuthorizationProvider;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.session.TicketResolverBase;
import io.deephaven.server.session.TicketRouter;
import io.grpc.StatusRuntimeException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.arrow.flight.impl.Flight;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ScopeTicketResolver
extends TicketResolverBase {
    @Inject
    public ScopeTicketResolver(AuthorizationProvider authProvider) {
        super(authProvider, (byte)115, "scope");
    }

    @Override
    public String getLogNameFor(ByteBuffer ticket, String logId) {
        return "scope/" + ScopeTicketResolver.nameForTicket(ticket, logId);
    }

    @Override
    public SessionState.ExportObject<Flight.FlightInfo> flightInfoFor(@Nullable SessionState session, Flight.FlightDescriptor descriptor, String logId) {
        String scopeName = ScopeTicketResolver.nameForDescriptor(descriptor, logId);
        QueryScope queryScope = ExecutionContext.getContext().getQueryScope();
        Object scopeVar = queryScope.unwrapObject(queryScope.readParamValue(scopeName, null));
        if (scopeVar == null) {
            throw ScopeTicketResolver.newNotFoundSRE(logId, scopeName);
        }
        if (!(scopeVar instanceof Table)) {
            throw ScopeTicketResolver.newNotFoundSRE(logId, scopeName);
        }
        Table transformed = this.authorization.transform((Table)scopeVar);
        if (transformed == null) {
            throw ScopeTicketResolver.newNotFoundSRE(logId, scopeName);
        }
        Flight.FlightInfo flightInfo = TicketRouter.getFlightInfo(transformed, descriptor, ScopeTicketResolver.flightTicketForName(scopeName));
        return SessionState.wrapAsExport(flightInfo);
    }

    @Override
    public void forAllFlightInfo(@Nullable SessionState session, Consumer<Flight.FlightInfo> visitor) {
        if (session == null) {
            return;
        }
        QueryScope queryScope = ExecutionContext.getContext().getQueryScope();
        queryScope.toMap(arg_0 -> ((QueryScope)queryScope).unwrapObject(arg_0), (n, t) -> t instanceof Table).forEach((name, table) -> {
            Table transformedTable = this.authorization.transform((Table)table);
            if (transformedTable != null) {
                visitor.accept(TicketRouter.getFlightInfo(transformedTable, ScopeTicketResolver.descriptorForName(name), ScopeTicketResolver.flightTicketForName(name)));
            }
        });
    }

    @Override
    public <T> SessionState.ExportObject<T> resolve(@Nullable SessionState session, ByteBuffer ticket, String logId) {
        return this.resolve(ScopeTicketResolver.nameForTicket(ticket, logId), logId);
    }

    @Override
    public <T> SessionState.ExportObject<T> resolve(@Nullable SessionState session, Flight.FlightDescriptor descriptor, String logId) {
        return this.resolve(ScopeTicketResolver.nameForDescriptor(descriptor, logId), logId);
    }

    private <T> SessionState.ExportObject<T> resolve(String scopeName, String logId) {
        Object export = null;
        try {
            QueryScope queryScope = ExecutionContext.getContext().getQueryScope();
            export = queryScope.unwrapObject(queryScope.readParamValue(scopeName));
        }
        catch (QueryScope.MissingVariableException missingVariableException) {
            // empty catch block
        }
        export = this.authorization.transform(export);
        if (export == null) {
            return SessionState.wrapAsFailedExport((Exception)ScopeTicketResolver.newNotFoundSRE(logId, scopeName));
        }
        return SessionState.wrapAsExport(export);
    }

    @Override
    public <T> SessionState.ExportBuilder<T> publish(SessionState session, ByteBuffer ticket, String logId, @Nullable Runnable onPublish) {
        return this.publish(session, ScopeTicketResolver.nameForTicket(ticket, logId), logId, onPublish);
    }

    @Override
    public <T> SessionState.ExportBuilder<T> publish(SessionState session, Flight.FlightDescriptor descriptor, String logId, @Nullable Runnable onPublish) {
        return this.publish(session, ScopeTicketResolver.nameForDescriptor(descriptor, logId), logId, onPublish);
    }

    private <T> SessionState.ExportBuilder<T> publish(SessionState session, String varName, String logId, @Nullable Runnable onPublish) {
        SessionState.ExportBuilder resultBuilder = session.nonExport();
        SessionState.ExportObject resultExport = resultBuilder.getExport();
        SessionState.ExportBuilder publishTask = session.nonExport();
        publishTask.requiresSerialQueue().require(resultExport).submit(() -> {
            Object value = resultExport.get();
            ExecutionContext.getContext().getQueryScope().putParam(varName, value);
            if (onPublish != null) {
                onPublish.run();
            }
        });
        return resultBuilder;
    }

    public static Flight.Ticket flightTicketForName(String name) {
        return Flight.Ticket.newBuilder().setTicket(ByteStringAccess.wrap((byte[])ScopeTicketHelper.nameToBytes((String)name))).build();
    }

    public static Ticket ticketForName(String name) {
        return Ticket.newBuilder().setTicket(ByteStringAccess.wrap((byte[])ScopeTicketHelper.nameToBytes((String)name))).build();
    }

    public static Flight.FlightDescriptor descriptorForName(String name) {
        return Flight.FlightDescriptor.newBuilder().setType(Flight.FlightDescriptor.DescriptorType.PATH).addAllPath((Iterable)ScopeTicketHelper.nameToPath((String)name)).build();
    }

    public static String nameForTicket(ByteBuffer ticket, String logId) {
        if (ticket == null || ticket.remaining() == 0) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': no ticket supplied"));
        }
        if (ticket.remaining() < 3 || ticket.get(ticket.position()) != 115 || ticket.get(ticket.position() + 1) != 47) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': found 0x" + ByteHelper.byteBufToHex((ByteBuffer)ticket) + "' (hex)"));
        }
        int initialPosition = ticket.position();
        CharsetDecoder decoder = EncodingInfo.UTF_8.getDecoder().reset();
        try {
            ticket.position(initialPosition + 2);
            String string = decoder.decode(ticket).toString();
            return string;
        }
        catch (CharacterCodingException e) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': failed to decode: " + e.getMessage()));
        }
        finally {
            ticket.position(initialPosition);
        }
    }

    public static String nameForDescriptor(Flight.FlightDescriptor descriptor, String logId) {
        if (descriptor.getType() != Flight.FlightDescriptor.DescriptorType.PATH) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve descriptor '" + logId + "': only paths are supported"));
        }
        if (descriptor.getPathCount() != 2) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve descriptor '" + logId + "': unexpected path length (found: " + TicketRouterHelper.getLogNameFor((Flight.FlightDescriptor)descriptor) + ", expected: 2)"));
        }
        if (!descriptor.getPath(0).equals("scope")) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve descriptor '" + logId + "': unexpected path (found: " + TicketRouterHelper.getLogNameFor((Flight.FlightDescriptor)descriptor) + ", expected: scope)"));
        }
        return descriptor.getPath(1);
    }

    public static Flight.FlightDescriptor ticketToDescriptor(Flight.Ticket ticket, String logId) {
        return ScopeTicketResolver.descriptorForName(ScopeTicketResolver.nameForTicket(ticket.getTicket().asReadOnlyByteBuffer(), logId));
    }

    public static Flight.Ticket descriptorToTicket(Flight.FlightDescriptor descriptor, String logId) {
        return ScopeTicketResolver.flightTicketForName(ScopeTicketResolver.nameForDescriptor(descriptor, logId));
    }

    @NotNull
    private static StatusRuntimeException newNotFoundSRE(String logId, String scopeName) {
        return Exceptions.statusRuntimeException((Code)Code.NOT_FOUND, (String)("Could not resolve '" + logId + ": variable '" + scopeName + "' not found"));
    }
}

