/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.console;

import com.google.common.base.Throwables;
import com.google.rpc.Code;
import io.deephaven.base.LockFreeArrayQueue;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.context.QueryScope;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.perf.QueryPerformanceNugget;
import io.deephaven.engine.table.impl.perf.QueryPerformanceRecorder;
import io.deephaven.engine.table.impl.util.RuntimeMemory;
import io.deephaven.engine.util.DelegatingScriptSession;
import io.deephaven.engine.util.ScriptSession;
import io.deephaven.engine.util.systemicmarking.SystemicObjectTracker;
import io.deephaven.extensions.barrage.util.GrpcUtil;
import io.deephaven.integrations.python.PythonDeephavenSession;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.LogBuffer;
import io.deephaven.io.logger.LogBufferRecord;
import io.deephaven.io.logger.LogBufferRecordListener;
import io.deephaven.io.logger.Logger;
import io.deephaven.lang.completion.CustomCompletion;
import io.deephaven.proto.backplane.grpc.FieldInfo;
import io.deephaven.proto.backplane.grpc.FieldsChangeUpdate;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.backplane.grpc.TypedTicket;
import io.deephaven.proto.backplane.script.grpc.AutoCompleteRequest;
import io.deephaven.proto.backplane.script.grpc.AutoCompleteResponse;
import io.deephaven.proto.backplane.script.grpc.BindTableToVariableRequest;
import io.deephaven.proto.backplane.script.grpc.BindTableToVariableResponse;
import io.deephaven.proto.backplane.script.grpc.CancelAutoCompleteRequest;
import io.deephaven.proto.backplane.script.grpc.CancelAutoCompleteResponse;
import io.deephaven.proto.backplane.script.grpc.CancelCommandRequest;
import io.deephaven.proto.backplane.script.grpc.CancelCommandResponse;
import io.deephaven.proto.backplane.script.grpc.ConsoleServiceGrpc;
import io.deephaven.proto.backplane.script.grpc.ExecuteCommandRequest;
import io.deephaven.proto.backplane.script.grpc.ExecuteCommandResponse;
import io.deephaven.proto.backplane.script.grpc.GetCompletionItemsResponse;
import io.deephaven.proto.backplane.script.grpc.GetConsoleTypesRequest;
import io.deephaven.proto.backplane.script.grpc.GetConsoleTypesResponse;
import io.deephaven.proto.backplane.script.grpc.GetHeapInfoRequest;
import io.deephaven.proto.backplane.script.grpc.GetHeapInfoResponse;
import io.deephaven.proto.backplane.script.grpc.LogSubscriptionData;
import io.deephaven.proto.backplane.script.grpc.LogSubscriptionRequest;
import io.deephaven.proto.backplane.script.grpc.StartConsoleRequest;
import io.deephaven.proto.backplane.script.grpc.StartConsoleResponse;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.console.ScopeTicketResolver;
import io.deephaven.server.console.completer.JavaAutoCompleteObserver;
import io.deephaven.server.console.completer.PythonAutoCompleteObserver;
import io.deephaven.server.session.SessionCloseableObserver;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.session.TicketRouter;
import io.deephaven.server.util.Scheduler;
import io.deephaven.util.SafeCloseable;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.jpy.PyObject;

@Singleton
public class ConsoleServiceGrpcImpl
extends ConsoleServiceGrpc.ConsoleServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(ConsoleServiceGrpcImpl.class);
    public static final boolean REMOTE_CONSOLE_DISABLED = Configuration.getInstance().getBooleanWithDefault("deephaven.console.disable", false);
    private static final String DISABLE_AUTOCOMPLETE_FLAG = "deephaven.console.autocomplete.disable";
    public static final boolean AUTOCOMPLETE_DISABLED = Configuration.getInstance().getBooleanWithDefault("deephaven.console.autocomplete.disable", false);
    public static final boolean QUIET_AUTOCOMPLETE_ERRORS = Configuration.getInstance().getBooleanWithDefault("deephaven.console.autocomplete.quiet", true);
    public static final long SUBSCRIBE_TO_LOGS_SEND_MILLIS = Configuration.getInstance().getLongWithDefault("deephaven.console.subscribeToLogs.sendMillis", 100L);
    public static final String SUBSCRIBE_TO_LOGS_BUFFER_SIZE_PROP = "deephaven.console.subscribeToLogs.bufferSize";
    public static final int SUBSCRIBE_TO_LOGS_BUFFER_SIZE = Configuration.getInstance().getIntegerWithDefault("deephaven.console.subscribeToLogs.bufferSize", 32768);
    private static final AtomicBoolean ALREADY_WARNED_ABOUT_NO_AUTOCOMPLETE = new AtomicBoolean();
    private final TicketRouter ticketRouter;
    private final SessionService sessionService;
    private final Provider<ScriptSession> scriptSessionProvider;
    private final Scheduler scheduler;
    private final LogBuffer logBuffer;
    private final Set<CustomCompletion.Factory> customCompletionFactory;

    @Inject
    public ConsoleServiceGrpcImpl(TicketRouter ticketRouter, SessionService sessionService, Provider<ScriptSession> scriptSessionProvider, Scheduler scheduler, LogBuffer logBuffer, Set<CustomCompletion.Factory> customCompletionFactory) {
        this.ticketRouter = ticketRouter;
        this.sessionService = sessionService;
        this.scriptSessionProvider = scriptSessionProvider;
        this.scheduler = Objects.requireNonNull(scheduler);
        this.logBuffer = Objects.requireNonNull(logBuffer);
        this.customCompletionFactory = customCompletionFactory;
    }

    public void getConsoleTypes(@NotNull GetConsoleTypesRequest request, @NotNull StreamObserver<GetConsoleTypesResponse> responseObserver) {
        if (!REMOTE_CONSOLE_DISABLED) {
            responseObserver.onNext((Object)GetConsoleTypesResponse.newBuilder().addConsoleTypes(((ScriptSession)this.scriptSessionProvider.get()).scriptType().toLowerCase()).build());
        } else {
            responseObserver.onNext((Object)GetConsoleTypesResponse.getDefaultInstance());
        }
        responseObserver.onCompleted();
    }

    public void startConsole(@NotNull StartConsoleRequest request, @NotNull StreamObserver<StartConsoleResponse> responseObserver) {
        SessionState session = this.sessionService.getCurrentSession();
        if (REMOTE_CONSOLE_DISABLED) {
            responseObserver.onError((Throwable)Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)"Remote console disabled"));
            return;
        }
        String sessionType = request.getSessionType();
        if (!((ScriptSession)this.scriptSessionProvider.get()).scriptType().equalsIgnoreCase(sessionType)) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("session type '" + sessionType + "' is not supported"));
        }
        session.newExport(request.getResultId(), "resultId").onError(responseObserver).submit(() -> {
            DelegatingScriptSession scriptSession = new DelegatingScriptSession((ScriptSession)this.scriptSessionProvider.get());
            GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)StartConsoleResponse.newBuilder().setResultId(request.getResultId()).build());
            return scriptSession;
        });
    }

    public void subscribeToLogs(@NotNull LogSubscriptionRequest request, @NotNull StreamObserver<LogSubscriptionData> responseObserver) {
        this.sessionService.getCurrentSession();
        if (REMOTE_CONSOLE_DISABLED) {
            GrpcUtil.safelyError(responseObserver, (Code)Code.FAILED_PRECONDITION, (String)"Remote console disabled");
            return;
        }
        LogsClient client = new LogsClient(request, (ServerCallStreamObserver<LogSubscriptionData>)((ServerCallStreamObserver)responseObserver));
        client.start();
    }

    public void executeCommand(@NotNull ExecuteCommandRequest request, @NotNull StreamObserver<ExecuteCommandResponse> responseObserver) {
        SessionState session = this.sessionService.getCurrentSession();
        Ticket consoleId = request.getConsoleId();
        if (consoleId.getTicket().isEmpty()) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)"No consoleId supplied");
        }
        String description = "ConsoleService#executeCommand(console=" + this.ticketRouter.getLogNameFor(consoleId, "consoleId") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject exportedConsole = this.ticketRouter.resolve(session, consoleId, "consoleId");
            session.nonExport().queryPerformanceRecorder(queryPerformanceRecorder).requiresSerialQueue().require(exportedConsole).onError(responseObserver).onSuccess(response -> GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)response)).submit(() -> {
                ScriptSession.Changes changes;
                ScriptSession scriptSession = (ScriptSession)exportedConsole.get();
                ExecuteCommandRequest.SystemicType systemicOption = request.hasSystemic() ? request.getSystemic() : ExecuteCommandRequest.SystemicType.NOT_SET_SYSTEMIC;
                switch (systemicOption) {
                    case NOT_SET_SYSTEMIC: {
                        changes = scriptSession.evaluateScript(request.getCode());
                        break;
                    }
                    case EXECUTE_NOT_SYSTEMIC: {
                        changes = (ScriptSession.Changes)SystemicObjectTracker.executeSystemically((boolean)false, () -> scriptSession.evaluateScript(request.getCode()));
                        break;
                    }
                    case EXECUTE_SYSTEMIC: {
                        changes = (ScriptSession.Changes)SystemicObjectTracker.executeSystemically((boolean)true, () -> scriptSession.evaluateScript(request.getCode()));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unrecognized systemic option: " + String.valueOf(systemicOption));
                    }
                }
                ExecuteCommandResponse.Builder diff = ExecuteCommandResponse.newBuilder();
                FieldsChangeUpdate.Builder fieldChanges = FieldsChangeUpdate.newBuilder();
                changes.created.entrySet().forEach(entry -> fieldChanges.addCreated(ConsoleServiceGrpcImpl.makeVariableDefinition(entry)));
                changes.updated.entrySet().forEach(entry -> fieldChanges.addUpdated(ConsoleServiceGrpcImpl.makeVariableDefinition(entry)));
                changes.removed.entrySet().forEach(entry -> fieldChanges.addRemoved(ConsoleServiceGrpcImpl.makeVariableDefinition(entry)));
                if (changes.error != null) {
                    diff.setErrorMessage(Throwables.getStackTraceAsString((Throwable)changes.error));
                    log.error().append((CharSequence)"Error running script: ").append((Throwable)changes.error).endl();
                }
                return diff.setChanges(fieldChanges).build();
            });
        }
    }

    public void getHeapInfo(@NotNull GetHeapInfoRequest request, @NotNull StreamObserver<GetHeapInfoResponse> responseObserver) {
        this.sessionService.getCurrentSession();
        RuntimeMemory runtimeMemory = RuntimeMemory.getInstance();
        RuntimeMemory.Sample sample = new RuntimeMemory.Sample();
        runtimeMemory.read(sample);
        GetHeapInfoResponse infoResponse = GetHeapInfoResponse.newBuilder().setTotalMemory(sample.totalMemory).setFreeMemory(sample.freeMemory).setMaxMemory(runtimeMemory.maxMemory()).build();
        responseObserver.onNext((Object)infoResponse);
        responseObserver.onCompleted();
    }

    private static FieldInfo makeVariableDefinition(Map.Entry<String, String> entry) {
        return ConsoleServiceGrpcImpl.makeVariableDefinition(entry.getKey(), entry.getValue());
    }

    private static FieldInfo makeVariableDefinition(String title, String type) {
        TypedTicket id = TypedTicket.newBuilder().setType(type).setTicket(ScopeTicketResolver.ticketForName(title)).build();
        return FieldInfo.newBuilder().setApplicationId("scope").setFieldName(title).setFieldDescription("query scope variable").setTypedTicket(id).build();
    }

    public void cancelCommand(@NotNull CancelCommandRequest request, @NotNull StreamObserver<CancelCommandResponse> responseObserver) {
        super.cancelCommand(request, responseObserver);
    }

    public void bindTableToVariable(@NotNull BindTableToVariableRequest request, @NotNull StreamObserver<BindTableToVariableResponse> responseObserver) {
        SessionState session = this.sessionService.getCurrentSession();
        Ticket tableId = request.getTableId();
        if (tableId.getTicket().isEmpty()) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)"No source tableId supplied");
        }
        String description = "ConsoleService#bindTableToVariable(table=" + this.ticketRouter.getLogNameFor(tableId, "tableId") + ", variableName=" + request.getVariableName() + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject exportedConsole;
            SessionState.ExportObject exportedTable = this.ticketRouter.resolve(session, tableId, "tableId");
            SessionState.ExportBuilder exportBuilder = session.nonExport().queryPerformanceRecorder(queryPerformanceRecorder).requiresSerialQueue().onError(responseObserver).onSuccess(() -> GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)BindTableToVariableResponse.getDefaultInstance()));
            if (request.hasConsoleId()) {
                exportedConsole = this.ticketRouter.resolve(session, request.getConsoleId(), "consoleId");
                exportBuilder.require(exportedTable, exportedConsole);
            } else {
                exportedConsole = null;
                exportBuilder.require(exportedTable);
            }
            exportBuilder.submit(() -> {
                QueryScope queryScope = exportedConsole != null ? ((ScriptSession)exportedConsole.get()).getQueryScope() : ExecutionContext.getContext().getQueryScope();
                Table table = (Table)exportedTable.get();
                queryScope.putParam(request.getVariableName(), (Object)table);
            });
        }
    }

    public StreamObserver<AutoCompleteRequest> autoCompleteStream(@NotNull StreamObserver<AutoCompleteResponse> responseObserver) {
        SessionState session = this.sessionService.getCurrentSession();
        if (AUTOCOMPLETE_DISABLED || ALREADY_WARNED_ABOUT_NO_AUTOCOMPLETE.get()) {
            return new NoopAutoCompleteObserver(session, responseObserver);
        }
        if (PythonDeephavenSession.SCRIPT_TYPE.equals(((ScriptSession)this.scriptSessionProvider.get()).scriptType())) {
            PyObject[] settings;
            block4: {
                settings = new PyObject[1];
                try {
                    ScriptSession scriptSession = (ScriptSession)this.scriptSessionProvider.get();
                    scriptSession.evaluateScript("from deephaven_internal.auto_completer import jedi_settings ; jedi_settings.set_scope(globals())");
                    settings[0] = (PyObject)scriptSession.getQueryScope().readParamValue("jedi_settings");
                }
                catch (Exception err) {
                    if (ALREADY_WARNED_ABOUT_NO_AUTOCOMPLETE.getAndSet(true)) break block4;
                    log.error().append((CharSequence)"Autocomplete package not found; disabling autocomplete.").endl();
                    log.error().append((CharSequence)"Do you need to install the autocomplete package?").endl();
                    log.error().append((CharSequence)"    pip install deephaven-core[autocomplete]==<version>").endl();
                    log.error().append((CharSequence)"Add the jvm flag '-D").append((CharSequence)DISABLE_AUTOCOMPLETE_FLAG).append((CharSequence)"=true' to disable this message.").endl();
                }
            }
            boolean canJedi = settings[0] != null && settings[0].call("can_jedi", new Object[0]).getBooleanValue();
            log.info().append((CharSequence)(canJedi ? "Using jedi for python autocomplete" : "No jedi dependency available in python environment; disabling autocomplete.")).endl();
            return canJedi ? new PythonAutoCompleteObserver(responseObserver, this.scriptSessionProvider, session) : new NoopAutoCompleteObserver(session, responseObserver);
        }
        return new JavaAutoCompleteObserver(session, responseObserver, this.customCompletionFactory);
    }

    public void cancelAutoComplete(@NotNull CancelAutoCompleteRequest request, @NotNull StreamObserver<CancelAutoCompleteResponse> responseObserver) {
        super.cancelAutoComplete(request, responseObserver);
    }

    private final class LogsClient
    implements LogBufferRecordListener,
    Runnable {
        private final LogSubscriptionRequest request;
        private final ServerCallStreamObserver<LogSubscriptionData> client;
        private final LockFreeArrayQueue<LogSubscriptionData> buffer;
        private final AtomicBoolean guard;
        private volatile boolean done;
        private volatile boolean tooSlow;

        public LogsClient(LogSubscriptionRequest request, ServerCallStreamObserver<LogSubscriptionData> client) {
            this.request = Objects.requireNonNull(request);
            this.client = Objects.requireNonNull(client);
            this.buffer = LockFreeArrayQueue.of((int)Math.max(SUBSCRIBE_TO_LOGS_BUFFER_SIZE, ConsoleServiceGrpcImpl.this.logBuffer.capacity() * 2));
            this.guard = new AtomicBoolean(false);
            this.client.setOnReadyHandler(this::onReady);
            this.client.setOnCancelHandler(this::onCancel);
            this.client.setOnCloseHandler(this::onClose);
        }

        public void start() {
            ConsoleServiceGrpcImpl.this.logBuffer.subscribe((LogBufferRecordListener)this);
            ConsoleServiceGrpcImpl.this.scheduler.runImmediately(this);
        }

        public void stop() {
            GrpcUtil.safelyComplete(this.client);
        }

        public void record(LogBufferRecord record) {
            if (this.done) {
                return;
            }
            if (this.request.getLevelsCount() != 0 && !this.request.getLevelsList().contains((Object)record.getLevel().getName())) {
                return;
            }
            if (record.getTimestampMicros() <= this.request.getLastSeenLogTimestamp()) {
                return;
            }
            LogSubscriptionData payload = LogSubscriptionData.newBuilder().setMicros(record.getTimestampMicros()).setLogLevel(record.getLevel().getName()).setMessage(record.getDataString()).build();
            this.enqueue(payload);
        }

        @Override
        public void run() {
            while (!this.done) {
                boolean bufferIsKnownEmpty;
                if (!this.guard.compareAndSet(false, true)) {
                    return;
                }
                try {
                    bufferIsKnownEmpty = false;
                    while (true) {
                        if (this.done) {
                            return;
                        }
                        if (this.tooSlow) {
                            GrpcUtil.safelyError(this.client, (Code)Code.RESOURCE_EXHAUSTED, (String)String.format("Too slow: the client or network may be too slow to keep up with the logging rates, or there may be logging bursts that exceed the available buffer size. The buffer size can be configured through the server property '%s'.", ConsoleServiceGrpcImpl.SUBSCRIBE_TO_LOGS_BUFFER_SIZE_PROP));
                            return;
                        }
                        if (!this.client.isReady()) {
                            break;
                        }
                        LogSubscriptionData payload = this.dequeue();
                        if (payload == null) {
                            bufferIsKnownEmpty = true;
                            break;
                        }
                        GrpcUtil.safelyOnNext(this.client, (Object)payload);
                    }
                }
                finally {
                    this.guard.set(false);
                }
                if (!this.client.isReady()) {
                    return;
                }
                if (!bufferIsKnownEmpty) continue;
                ConsoleServiceGrpcImpl.this.scheduler.runAfterDelay(SUBSCRIBE_TO_LOGS_SEND_MILLIS, this);
                return;
            }
        }

        private void onReady() {
            ConsoleServiceGrpcImpl.this.scheduler.runImmediately(this);
        }

        private void onClose() {
            this.done = true;
            ConsoleServiceGrpcImpl.this.logBuffer.unsubscribe((LogBufferRecordListener)this);
        }

        private void onCancel() {
            this.done = true;
            ConsoleServiceGrpcImpl.this.logBuffer.unsubscribe((LogBufferRecordListener)this);
        }

        private void enqueue(LogSubscriptionData payload) {
            if (!this.buffer.enqueue((Object)payload)) {
                this.tooSlow = true;
                ConsoleServiceGrpcImpl.this.logBuffer.unsubscribe((LogBufferRecordListener)this);
                ConsoleServiceGrpcImpl.this.scheduler.runImmediately(this);
            }
        }

        private LogSubscriptionData dequeue() {
            return (LogSubscriptionData)this.buffer.dequeue();
        }
    }

    private static class NoopAutoCompleteObserver
    extends SessionCloseableObserver<AutoCompleteResponse>
    implements StreamObserver<AutoCompleteRequest> {
        public NoopAutoCompleteObserver(SessionState session, StreamObserver<AutoCompleteResponse> responseObserver) {
            super(session, responseObserver);
        }

        public void onNext(AutoCompleteRequest value) {
            AutoCompleteResponse.Builder responseBuilder = AutoCompleteResponse.newBuilder().setSuccess(true).setRequestId(value.getRequestId());
            if (value.getRequestCase() == AutoCompleteRequest.RequestCase.GET_COMPLETION_ITEMS) {
                responseBuilder.setCompletionItems(GetCompletionItemsResponse.newBuilder().setSuccess(true).setRequestId(value.getRequestId()));
            }
            GrpcUtil.safelyOnNext((StreamObserver)this.responseObserver, (Object)responseBuilder.build());
        }

        public void onError(Throwable t) {
        }

        public void onCompleted() {
            GrpcUtil.safelyComplete((StreamObserver)this.responseObserver);
        }
    }
}

