/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.console;

import com.google.protobuf.Message;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.backplane.script.grpc.AutoCompleteRequest;
import io.deephaven.proto.backplane.script.grpc.AutoCompleteResponse;
import io.deephaven.proto.backplane.script.grpc.BrowserNextResponse;
import io.deephaven.proto.backplane.script.grpc.ConsoleServiceGrpc;
import io.deephaven.server.auth.AuthorizationProvider;
import io.deephaven.server.browserstreaming.BrowserStream;
import io.deephaven.server.console.ConsoleServiceGrpcImpl;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.util.GrpcServiceOverrideBuilder;
import io.grpc.BindableService;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import javax.inject.Inject;

public class ConsoleServiceGrpcBinding
implements BindableService {
    private static final Logger log = LoggerFactory.getLogger(ConsoleServiceGrpcBinding.class);
    private final AuthorizationProvider authProvider;
    private final ConsoleServiceGrpcImpl delegate;
    private final SessionService sessionService;

    @Inject
    public ConsoleServiceGrpcBinding(AuthorizationProvider authProvider, ConsoleServiceGrpcImpl delegate, SessionService sessionService) {
        this.authProvider = authProvider;
        this.delegate = delegate;
        this.sessionService = sessionService;
    }

    public ServerServiceDefinition bindService() {
        ServerServiceDefinition authIntercepted = this.authProvider.getConsoleServiceAuthWiring().intercept((ConsoleServiceGrpc.ConsoleServiceImplBase)this.delegate);
        return GrpcServiceOverrideBuilder.newBuilder(authIntercepted).onBidiOverrideWithBrowserSupport(this.delegate::autoCompleteStream, ConsoleServiceGrpc.getAutoCompleteStreamMethod(), ConsoleServiceGrpc.getOpenAutoCompleteStreamMethod(), ConsoleServiceGrpc.getNextAutoCompleteStreamMethod(), ProtoUtils.marshaller((Message)AutoCompleteRequest.getDefaultInstance()), ProtoUtils.marshaller((Message)AutoCompleteResponse.getDefaultInstance()), ProtoUtils.marshaller((Message)BrowserNextResponse.getDefaultInstance()), BrowserStream.Mode.IN_ORDER, log, this.sessionService).build();
    }
}

