/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.config;

import io.deephaven.configuration.Configuration;
import io.deephaven.server.runner.MainHelper;
import io.deephaven.ssl.config.SSLConfig;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import org.immutables.value.Value;

public interface ServerConfig {
    public static final int DEFAULT_SCHEDULER_POOL_SIZE = 4;
    public static final int DEFAULT_MAX_INBOUND_MESSAGE_SIZE_MiB = 100;
    public static final int DEFAULT_SHUTDOWN_TIMEOUT_MILLIS = 10000;
    public static final String HTTP_SESSION_DURATION_MS = "http.session.durationMs";
    public static final String HTTP_HOST = "http.host";
    public static final String HTTP_PORT = "http.port";
    public static final String HTTP_TARGET_URL = "http.targetUrl";
    public static final String SCHEDULER_POOL_SIZE = "scheduler.poolSize";
    public static final String GRPC_MAX_INBOUND_MESSAGE_SIZE = "grpc.maxInboundMessageSize";
    public static final String PROXY_HINT = "proxy.hint";
    public static final String SHUTDOWN_TIMEOUT_MILLIS = "shutdown.timeoutMs";

    public static <B extends Builder<?, B>> B buildFromConfig(B builder, Configuration config) {
        int httpSessionExpireMs = config.getIntegerWithDefault(HTTP_SESSION_DURATION_MS, -1);
        String httpHost = config.getStringWithDefault(HTTP_HOST, null);
        int httpPort = config.getIntegerWithDefault(HTTP_PORT, -1);
        String httpTargetUrl = config.getStringWithDefault(HTTP_TARGET_URL, null);
        int schedulerPoolSize = config.getIntegerWithDefault(SCHEDULER_POOL_SIZE, -1);
        int maxInboundMessageSize = config.getIntegerWithDefault(GRPC_MAX_INBOUND_MESSAGE_SIZE, -1);
        String proxyHint = config.getStringWithDefault(PROXY_HINT, null);
        int shutdownTimeoutMillis = config.getIntegerWithDefault(SHUTDOWN_TIMEOUT_MILLIS, -1);
        if (httpSessionExpireMs > -1) {
            builder.tokenExpire(Duration.ofMillis(httpSessionExpireMs));
        }
        if (httpHost != null) {
            builder.host(httpHost);
        }
        if (httpPort != -1) {
            builder.port(httpPort);
        }
        if (httpTargetUrl != null) {
            builder.targetUrl(httpTargetUrl);
        }
        if (schedulerPoolSize != -1) {
            builder.schedulerPoolSize(schedulerPoolSize);
        }
        if (maxInboundMessageSize != -1) {
            builder.maxInboundMessageSize(maxInboundMessageSize);
        }
        if (proxyHint != null) {
            builder.proxyHint(Boolean.parseBoolean(proxyHint));
        }
        if (shutdownTimeoutMillis != -1) {
            builder.shutdownTimeout(Duration.ofMillis(shutdownTimeoutMillis));
        }
        MainHelper.parseSSLConfig(config).ifPresent(builder::ssl);
        MainHelper.parseOutboundSSLConfig(config).ifPresent(builder::outboundSsl);
        return builder;
    }

    public Optional<String> host();

    public int port();

    public Optional<String> targetUrl();

    public Optional<SSLConfig> ssl();

    public Optional<SSLConfig> outboundSsl();

    public Duration tokenExpire();

    @Value.Default
    default public int schedulerPoolSize() {
        return 4;
    }

    @Value.Default
    default public int maxInboundMessageSize() {
        return 0x6400000;
    }

    @Value.Default
    default public Duration shutdownTimeout() {
        return Duration.ofMillis(10000L);
    }

    @Nullable
    public Boolean proxyHint();

    default public String targetUrlOrDefault() {
        Optional<String> targetUrl = this.targetUrl();
        if (targetUrl.isPresent()) {
            return targetUrl.get();
        }
        String host = this.host().orElse("localhost");
        int port = this.port();
        if (this.ssl().isPresent()) {
            if (port == 443) {
                return String.format("https://%s", host);
            }
            return String.format("https://%s:%d", host, port);
        }
        if (port == 80) {
            return String.format("http://%s", host);
        }
        return String.format("http://%s:%d", host, port);
    }

    public static interface Builder<T, B extends Builder<T, B>> {
        public B host(String var1);

        public B port(int var1);

        public B targetUrl(String var1);

        public B ssl(SSLConfig var1);

        public B outboundSsl(SSLConfig var1);

        public B tokenExpire(Duration var1);

        public B schedulerPoolSize(int var1);

        public B maxInboundMessageSize(int var1);

        public B proxyHint(Boolean var1);

        public B shutdownTimeout(Duration var1);

        public T build();
    }
}

