/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.config;

import io.deephaven.configuration.Configuration;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.backplane.grpc.AuthenticationConstantsRequest;
import io.deephaven.proto.backplane.grpc.AuthenticationConstantsResponse;
import io.deephaven.proto.backplane.grpc.ConfigServiceGrpc;
import io.deephaven.proto.backplane.grpc.ConfigValue;
import io.deephaven.proto.backplane.grpc.ConfigurationConstantsRequest;
import io.deephaven.proto.backplane.grpc.ConfigurationConstantsResponse;
import io.deephaven.server.session.SessionService;
import io.grpc.stub.StreamObserver;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class ConfigServiceGrpcImpl
extends ConfigServiceGrpc.ConfigServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(ConfigServiceGrpcImpl.class);
    private static final String VERSION_LIST_PROPERTY = "client.version.list";
    private static final String AUTH_CLIENT_CONFIG_PROPERTY = "authentication.client.configuration.list";
    private static final String CLIENT_CONFIG_PROPERTY = "client.configuration.list";
    private final Configuration configuration = Configuration.getInstance();
    private final SessionService sessionService;

    @Inject
    public ConfigServiceGrpcImpl(SessionService sessionService) {
        this.sessionService = sessionService;
        for (String pair : this.configuration.getStringArrayFromProperty(VERSION_LIST_PROPERTY)) {
            if ((pair = pair.trim()).isEmpty()) continue;
            String[] split = pair.split("=");
            if (split.length != 2) {
                throw new IllegalArgumentException("Missing '=' in client.version.list");
            }
            String key = split[0] + ".version";
            if (this.configuration.hasProperty(key)) {
                throw new IllegalArgumentException("Configuration already has a key for '" + key + "'");
            }
            String className = split[1];
            try {
                this.configuration.setProperty(key, Class.forName(className, false, ((Object)((Object)this)).getClass().getClassLoader()).getPackage().getImplementationVersion());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Failed to find class to get its version '" + className + "'");
            }
        }
    }

    public void getAuthenticationConstants(@NotNull AuthenticationConstantsRequest request, @NotNull StreamObserver<AuthenticationConstantsResponse> responseObserver) {
        AuthenticationConstantsResponse.Builder builder = AuthenticationConstantsResponse.newBuilder();
        builder.putAllConfigValues(this.collectConfigs(AUTH_CLIENT_CONFIG_PROPERTY));
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void getConfigurationConstants(@NotNull ConfigurationConstantsRequest request, @NotNull StreamObserver<ConfigurationConstantsResponse> responseObserver) {
        this.sessionService.getCurrentSession();
        ConfigurationConstantsResponse.Builder builder = ConfigurationConstantsResponse.newBuilder();
        builder.putAllConfigValues(this.collectConfigs(CLIENT_CONFIG_PROPERTY));
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    private Map<String, ConfigValue> collectConfigs(String clientConfigProperty) {
        return Arrays.stream(this.configuration.getStringWithDefault(clientConfigProperty, "").split(",")).map(String::trim).filter(key -> !key.isEmpty()).map(key -> {
            String value = this.configuration.getStringWithDefault(key, null);
            if (value == null) {
                return null;
            }
            return Map.entry(key, ConfigValue.newBuilder().setStringValue(value).build());
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

