/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.browserstreaming;

import com.google.rpc.Code;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.proto.util.ExportTicketHelper;
import io.deephaven.server.browserstreaming.StreamData;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;

public class BrowserStreamInterceptor
implements ServerInterceptor {
    public static final String TICKET_HEADER_NAME = "x-deephaven-stream-ticket";
    public static final String SEQUENCE_HEADER_NAME = "x-deephaven-stream-sequence";
    public static final String HALF_CLOSE_HEADER_NAME = "x-deephaven-stream-halfclose";
    private static final Metadata.Key<String> RPC_TICKET = Metadata.Key.of((String)"x-deephaven-stream-ticket", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> SEQ_HEADER = Metadata.Key.of((String)"x-deephaven-stream-sequence", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> HALF_CLOSE_HEADER = Metadata.Key.of((String)"x-deephaven-stream-halfclose", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        boolean hasSeqString;
        String ticketInt = (String)headers.get(RPC_TICKET);
        String sequenceString = (String)headers.get(SEQ_HEADER);
        boolean hasTicket = ticketInt != null;
        boolean bl = hasSeqString = sequenceString != null;
        if (hasTicket != hasSeqString) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Either both x-deephaven-stream-ticket and x-deephaven-stream-sequence must be provided, or neither");
        }
        boolean hasHalfClose = headers.containsKey(HALF_CLOSE_HEADER);
        if (ticketInt != null) {
            Ticket rpcTicket = ExportTicketHelper.wrapExportIdInTicket((int)Integer.parseInt(ticketInt));
            StreamData data = new StreamData(rpcTicket, Integer.parseInt(sequenceString), hasHalfClose);
            Context ctx = Context.current().withValue(StreamData.STREAM_DATA_KEY, (Object)data);
            return Contexts.interceptCall((Context)ctx, call, (Metadata)headers, next);
        }
        if (hasHalfClose) {
            StreamData data = new StreamData(null, 0, hasHalfClose);
            Context ctx = Context.current().withValue(StreamData.STREAM_DATA_KEY, (Object)data);
            return Contexts.interceptCall((Context)ctx, call, (Metadata)headers, next);
        }
        return next.startCall(call, headers);
    }
}

