/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.auth;

import dagger.Module;
import dagger.Provides;
import io.deephaven.UncheckedDeephavenException;
import io.deephaven.auth.AuthenticationRequestHandler;
import io.deephaven.auth.BasicAuthMarshaller;
import io.deephaven.configuration.Configuration;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@Module
public class AuthContextModule {
    private static final Logger log = LoggerFactory.getLogger(AuthContextModule.class);
    private static final String[] AUTH_HANDLERS = Configuration.getInstance().getStringArrayFromProperty("AuthHandlers");
    private static Map<String, AuthenticationRequestHandler> authHandlerMap;

    private static void initializeAuthHandlers() {
        if (authHandlerMap != null) {
            return;
        }
        authHandlerMap = new LinkedHashMap<String, AuthenticationRequestHandler>();
        for (String handler : AUTH_HANDLERS) {
            try {
                Class<?> clazz = AuthContextModule.class.getClassLoader().loadClass(handler);
                Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (instance instanceof BasicAuthMarshaller.Handler) {
                    instance = new BasicAuthMarshaller((BasicAuthMarshaller.Handler)instance);
                }
                if (instance instanceof AuthenticationRequestHandler) {
                    AuthenticationRequestHandler authHandler = (AuthenticationRequestHandler)instance;
                    AuthenticationRequestHandler existing = authHandlerMap.put(authHandler.getAuthType(), authHandler);
                    if (existing == null) continue;
                    log.error().append((CharSequence)"Multiple handlers registered for authentication type ").append((CharSequence)existing.getAuthType()).end();
                    throw new UncheckedDeephavenException("Multiple authentication handlers registered for type " + existing.getAuthType());
                }
                log.error().append((CharSequence)"Provided auth handler does not implement an auth interface: ").append((CharSequence)handler).endl();
                throw new UncheckedDeephavenException("Could not load authentication");
            }
            catch (Exception error) {
                log.error().append((CharSequence)"Could not load authentication handler class: ").append((CharSequence)handler).endl();
                log.error().append((Throwable)error).endl();
                throw new UncheckedDeephavenException((Throwable)error);
            }
        }
        authHandlerMap = Collections.unmodifiableMap(authHandlerMap);
    }

    @Provides
    public Map<String, AuthenticationRequestHandler> bindAuthHandlerMap() {
        AuthContextModule.initializeAuthHandlers();
        return authHandlerMap;
    }
}

