/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.arrow;

import io.grpc.stub.ServerCallStreamObserver;
import java.util.Objects;
import java.util.function.Function;

final class ServerCallStreamObserverAdapter<T, R>
extends ServerCallStreamObserver<T> {
    private final ServerCallStreamObserver<R> delegate;
    private final Function<T, R> f;

    ServerCallStreamObserverAdapter(ServerCallStreamObserver<R> delegate, Function<T, R> f) {
        this.delegate = Objects.requireNonNull(delegate);
        this.f = Objects.requireNonNull(f);
    }

    public void onNext(T value) {
        this.delegate.onNext(this.f.apply(value));
    }

    public void onError(Throwable t) {
        this.delegate.onError(t);
    }

    public void onCompleted() {
        this.delegate.onCompleted();
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public void setOnCancelHandler(Runnable onCancelHandler) {
        this.delegate.setOnCancelHandler(onCancelHandler);
    }

    public void setCompression(String compression) {
        this.delegate.setCompression(compression);
    }

    public boolean isReady() {
        return this.delegate.isReady();
    }

    public void setOnReadyHandler(Runnable onReadyHandler) {
        this.delegate.setOnReadyHandler(onReadyHandler);
    }

    public void request(int count) {
        this.delegate.request(count);
    }

    public void setMessageCompression(boolean enable) {
        this.delegate.setMessageCompression(enable);
    }

    public void disableAutoInboundFlowControl() {
        this.delegate.disableAutoInboundFlowControl();
    }
}

