/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.arrow;

import com.google.auto.service.AutoService;
import com.google.rpc.Code;
import io.deephaven.barrage.flatbuf.BarrageSnapshotRequest;
import io.deephaven.barrage.flatbuf.BarrageSubscriptionRequest;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.liveness.LivenessReferent;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.extensions.barrage.BarrageMessageWriter;
import io.deephaven.extensions.barrage.BarragePerformanceLog;
import io.deephaven.extensions.barrage.BarrageSnapshotOptions;
import io.deephaven.extensions.barrage.BarrageSubscriptionOptions;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.arrow.BarrageRequestHelpers;
import io.deephaven.server.arrow.ExchangeMarshaller;
import io.deephaven.server.arrow.ExchangeMarshallerModule;
import io.deephaven.server.hierarchicaltable.HierarchicalTableView;
import io.deephaven.server.hierarchicaltable.HierarchicalTableViewSubscription;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.util.Scheduler;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.annotations.ReflexiveUse;
import io.grpc.stub.StreamObserver;
import java.util.BitSet;

@ReflexiveUse(referrers={"ExchangeMarshallerModule"})
public class HierarchicalTableViewExchangeMarshaller
implements ExchangeMarshaller {
    private final HierarchicalTableViewSubscription.Factory htvsFactory;

    public HierarchicalTableViewExchangeMarshaller(HierarchicalTableViewSubscription.Factory htvsFactory) {
        this.htvsFactory = htvsFactory;
    }

    @Override
    public int priority() {
        return 1000;
    }

    @Override
    public boolean accept(Object export) {
        return export instanceof HierarchicalTableView;
    }

    @Override
    public void snapshot(BarrageSnapshotRequest snapshotRequest, BarrageSnapshotOptions options, Object export, BarragePerformanceLog.SnapshotMetricsHelper metrics, StreamObserver<BarrageMessageWriter.MessageView> listener, String ticketLogName, BarrageMessageWriter.Factory streamGeneratorFactory) {
        throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Ticket (" + ticketLogName + ") is a HierarchicalTableView and does not support snapshots."));
    }

    @Override
    public ExchangeMarshaller.Subscription subscribe(BarrageSubscriptionRequest subscriptionRequest, BarrageSubscriptionOptions options, Object export, StreamObserver<BarrageMessageWriter.MessageView> listener) {
        HierarchicalTableViewSubscription htvs;
        long minUpdateIntervalMs = BarrageRequestHelpers.getMinUpdateIntervalMs(subscriptionRequest.subscriptionOptions());
        HierarchicalTableView hierarchicalTableView = (HierarchicalTableView)((Object)export);
        boolean isRefreshing = hierarchicalTableView.getHierarchicalTable().getSource().isRefreshing();
        UpdateGraph ug = hierarchicalTableView.getHierarchicalTable().getSource().getUpdateGraph();
        try (SafeCloseable ignored = ExecutionContext.getContext().withUpdateGraph(ug).open();){
            htvs = this.htvsFactory.create(hierarchicalTableView, listener, options, minUpdateIntervalMs);
        }
        BitSet columns = BarrageRequestHelpers.getColumns(subscriptionRequest);
        RowSet viewport = BarrageRequestHelpers.getViewport(subscriptionRequest);
        boolean reverseViewport = subscriptionRequest.reverseViewport();
        htvs.setViewport(columns, viewport, reverseViewport);
        return new Subscription(htvs);
    }

    private static class Subscription
    implements ExchangeMarshaller.Subscription {
        private final HierarchicalTableViewSubscription htvs;

        private Subscription(HierarchicalTableViewSubscription htvs) {
            this.htvs = htvs;
        }

        @Override
        public LivenessReferent toManage() {
            return this.htvs;
        }

        @Override
        public void close() {
            this.htvs.completed();
        }

        @Override
        public boolean update(BarrageSubscriptionRequest subscriptionRequest) {
            BitSet columns = BarrageRequestHelpers.getColumns(subscriptionRequest);
            RowSet viewport = BarrageRequestHelpers.getViewport(subscriptionRequest);
            boolean reverseViewport = subscriptionRequest.reverseViewport();
            this.htvs.setViewport(columns, viewport, reverseViewport);
            return true;
        }
    }

    @AutoService(value={ExchangeMarshallerModule.Factory.class})
    public static class Factory
    implements ExchangeMarshallerModule.Factory {
        @Override
        public HierarchicalTableViewExchangeMarshaller create(Scheduler scheduler, SessionService.ErrorTransformer errorTransformer, BarrageMessageWriter.Factory streamGeneratorFactory) {
            HierarchicalTableViewSubscription.Factory htvsFactory = (view, listener, subscriptionOptions, intervalMillis) -> new HierarchicalTableViewSubscription(scheduler, errorTransformer, streamGeneratorFactory, view, (StreamObserver<BarrageMessageWriter.MessageView>)listener, subscriptionOptions, intervalMillis);
            return new HierarchicalTableViewExchangeMarshaller(htvsFactory);
        }
    }
}

