/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.arrow;

import com.github.f4b6a3.uuid.UuidCreator;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.google.protobuf.ByteString;
import com.google.protobuf.ByteStringAccess;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.rpc.Code;
import io.deephaven.auth.AuthContext;
import io.deephaven.auth.AuthenticationException;
import io.deephaven.auth.AuthenticationRequestHandler;
import io.deephaven.auth.BasicAuthMarshaller;
import io.deephaven.engine.table.impl.perf.QueryPerformanceNugget;
import io.deephaven.engine.table.impl.perf.QueryPerformanceRecorder;
import io.deephaven.engine.table.impl.util.EngineMetrics;
import io.deephaven.extensions.barrage.BarrageMessageWriter;
import io.deephaven.extensions.barrage.util.GrpcUtil;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.backplane.grpc.ExportNotification;
import io.deephaven.proto.backplane.grpc.WrappedAuthenticationRequest;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.arrow.ArrowFlightUtil;
import io.deephaven.server.arrow.ServerCallStreamObserverAdapter;
import io.deephaven.server.session.ActionRouter;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.session.TicketRouter;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.arrow.flight.ProtocolExposer;
import org.apache.arrow.flight.Result;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.flight.impl.FlightServiceGrpc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class FlightServiceGrpcImpl
extends FlightServiceGrpc.FlightServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(FlightServiceGrpcImpl.class);
    private final ScheduledExecutorService executorService;
    private final BarrageMessageWriter.Factory streamGeneratorFactory;
    private final SessionService sessionService;
    private final SessionService.ErrorTransformer errorTransformer;
    private final TicketRouter ticketRouter;
    private final ActionRouter actionRouter;
    private final ArrowFlightUtil.DoExchangeMarshaller.Factory doExchangeFactory;
    private final Map<String, AuthenticationRequestHandler> authRequestHandlers;

    @Inject
    public FlightServiceGrpcImpl(@Nullable ScheduledExecutorService executorService, BarrageMessageWriter.Factory streamGeneratorFactory, SessionService sessionService, SessionService.ErrorTransformer errorTransformer, TicketRouter ticketRouter, ActionRouter actionRouter, ArrowFlightUtil.DoExchangeMarshaller.Factory doExchangeFactory, Map<String, AuthenticationRequestHandler> authRequestHandlers) {
        this.executorService = executorService;
        this.streamGeneratorFactory = streamGeneratorFactory;
        this.sessionService = sessionService;
        this.errorTransformer = errorTransformer;
        this.ticketRouter = ticketRouter;
        this.actionRouter = actionRouter;
        this.doExchangeFactory = doExchangeFactory;
        this.authRequestHandlers = authRequestHandlers;
    }

    public StreamObserver<Flight.HandshakeRequest> handshake(final @NotNull StreamObserver<Flight.HandshakeResponse> responseObserver) {
        SessionState session = this.sessionService.getOptionalSession();
        if (session != null) {
            return new StreamObserver<Flight.HandshakeRequest>(){

                public void onNext(Flight.HandshakeRequest value) {
                }

                public void onError(Throwable t) {
                }

                public void onCompleted() {
                    GrpcUtil.safelyComplete((StreamObserver)responseObserver);
                }
            };
        }
        return new HandshakeObserver(responseObserver);
    }

    public void doAction(Flight.Action request, StreamObserver<Flight.Result> responseObserver) {
        this.actionRouter.doAction(this.sessionService.getOptionalSession(), ProtocolExposer.fromProtocol((Flight.Action)request), (StreamObserver<Result>)new ServerCallStreamObserverAdapter<Result, Flight.Result>((ServerCallStreamObserver)responseObserver, ProtocolExposer::toProtocol));
    }

    public void listFlights(@NotNull Flight.Criteria request, @NotNull StreamObserver<Flight.FlightInfo> responseObserver) {
        if (!request.getExpression().isEmpty()) {
            responseObserver.onError((Throwable)Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Criteria expressions are not supported"));
            return;
        }
        this.ticketRouter.visitFlightInfo(this.sessionService.getOptionalSession(), arg_0 -> responseObserver.onNext(arg_0));
        responseObserver.onCompleted();
    }

    public void listActions(Flight.Empty request, StreamObserver<Flight.ActionType> responseObserver) {
        this.actionRouter.listActions(this.sessionService.getOptionalSession(), FlightServiceGrpcImpl.adapt(arg_0 -> responseObserver.onNext(arg_0), ProtocolExposer::toProtocol));
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void getFlightInfo(@NotNull Flight.FlightDescriptor request, @NotNull StreamObserver<Flight.FlightInfo> responseObserver) {
        session = this.sessionService.getOptionalSession();
        description = "FlightService#getFlightInfo(request=" + String.valueOf(request) + ")";
        queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)(session == null ? null : session.getSessionId()), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        ignored = queryPerformanceRecorder.startQuery();
        try {
            export = this.ticketRouter.flightInfoFor(session, request, "request");
            if (session != null) {
                session.nonExport().queryPerformanceRecorder(queryPerformanceRecorder).require(new SessionState.ExportObject[]{export}).onError(responseObserver).onSuccess((Consumer<Flight.FlightInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getFlightInfo$0(io.grpc.stub.StreamObserver org.apache.arrow.flight.impl.Flight$FlightInfo ), (Lorg/apache/arrow/flight/impl/Flight$FlightInfo;)V)(responseObserver)).submit((Callable<Flight.FlightInfo>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, get(), ()Lorg/apache/arrow/flight/impl/Flight$FlightInfo;)(export));
                return;
            }
            exception = null;
            if (export.tryRetainReference()) {
                try {
                    if (export.getState() != ExportNotification.State.EXPORTED) ** GOTO lbl25
                    GrpcUtil.safelyOnNextAndComplete(responseObserver, (Object)export.get());
                }
                finally {
                    export.dropReference();
                }
            } else {
                exception = Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)"Could not find flight info");
                GrpcUtil.safelyError(responseObserver, (StatusRuntimeException)exception);
            }
lbl25:
            // 3 sources

            if (queryPerformanceRecorder.endQuery() || exception != null) {
                EngineMetrics.getInstance().logQueryProcessingResults(queryPerformanceRecorder, (Exception)exception);
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void getSchema(@NotNull Flight.FlightDescriptor request, @NotNull StreamObserver<Flight.SchemaResult> responseObserver) {
        session = this.sessionService.getOptionalSession();
        description = "FlightService#getSchema(request=" + String.valueOf(request) + ")";
        queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)(session == null ? null : session.getSessionId()), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        ignored = queryPerformanceRecorder.startQuery();
        try {
            export = this.ticketRouter.flightInfoFor(session, request, "request");
            if (session != null) {
                session.nonExport().queryPerformanceRecorder(queryPerformanceRecorder).require(new SessionState.ExportObject[]{export}).onError(responseObserver).onSuccess((Consumer<Flight.SchemaResult>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getSchema$1(io.grpc.stub.StreamObserver org.apache.arrow.flight.impl.Flight$SchemaResult ), (Lorg/apache/arrow/flight/impl/Flight$SchemaResult;)V)(responseObserver)).submit((Callable<Flight.SchemaResult>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getSchema$2(io.deephaven.server.session.SessionState$ExportObject ), ()Lorg/apache/arrow/flight/impl/Flight$SchemaResult;)(export));
                return;
            }
            exception = null;
            if (export.tryRetainReference()) {
                try {
                    if (export.getState() != ExportNotification.State.EXPORTED) ** GOTO lbl22
                    GrpcUtil.safelyOnNextAndComplete(responseObserver, (Object)Flight.SchemaResult.newBuilder().setSchema(export.get().getSchema()).build());
                }
                finally {
                    export.dropReference();
                }
            } else {
                exception = Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)"Could not find flight info");
                responseObserver.onError((Throwable)exception);
            }
lbl22:
            // 3 sources

            if (queryPerformanceRecorder.endQuery() || exception != null) {
                EngineMetrics.getInstance().logQueryProcessingResults(queryPerformanceRecorder, (Exception)exception);
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    public void doGetCustom(Flight.Ticket request, StreamObserver<InputStream> responseObserver) {
        ArrowFlightUtil.DoGetCustom(this.streamGeneratorFactory, this.sessionService.getCurrentSession(), this.ticketRouter, request, responseObserver);
    }

    public StreamObserver<InputStream> doPutCustom(StreamObserver<Flight.PutResult> responseObserver) {
        return new ArrowFlightUtil.DoPutObserver(this.sessionService.getCurrentSession(), this.ticketRouter, this.errorTransformer, responseObserver);
    }

    public StreamObserver<InputStream> doExchangeCustom(StreamObserver<InputStream> responseObserver) {
        return this.doExchangeFactory.openExchange(this.sessionService.getCurrentSession(), responseObserver);
    }

    private static <T, R> Consumer<T> adapt(Consumer<R> consumer, Function<? super T, ? extends R> function) {
        return t -> consumer.accept(function.apply(t));
    }

    private static /* synthetic */ Flight.SchemaResult lambda$getSchema$2(SessionState.ExportObject export) throws Exception {
        return Flight.SchemaResult.newBuilder().setSchema(((Flight.FlightInfo)export.get()).getSchema()).build();
    }

    private static /* synthetic */ void lambda$getSchema$1(StreamObserver responseObserver, Flight.SchemaResult resultSchema) {
        GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)resultSchema);
    }

    private static /* synthetic */ void lambda$getFlightInfo$0(StreamObserver responseObserver, Flight.FlightInfo resultFlightInfo) {
        GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)resultFlightInfo);
    }

    private final class HandshakeObserver
    implements StreamObserver<Flight.HandshakeRequest> {
        private boolean isComplete = false;
        private final StreamObserver<Flight.HandshakeResponse> responseObserver;

        private HandshakeObserver(StreamObserver<Flight.HandshakeResponse> responseObserver) {
            this.responseObserver = responseObserver;
        }

        public void onNext(Flight.HandshakeRequest value) {
            Optional<Object> auth;
            AuthenticationRequestHandler.HandshakeResponseListener handshakeResponseListener = (protocol, response) -> GrpcUtil.safelyOnNextAndComplete(this.responseObserver, (Object)Flight.HandshakeResponse.newBuilder().setProtocolVersion(protocol).setPayload(ByteStringAccess.wrap((ByteBuffer)response)).build());
            ByteString payload = value.getPayload();
            long protocolVersion = value.getProtocolVersion();
            try {
                auth = this.login(BasicAuthMarshaller.AUTH_TYPE, protocolVersion, payload, handshakeResponseListener);
                if (auth.isEmpty()) {
                    WrappedAuthenticationRequest req = WrappedAuthenticationRequest.parseFrom((ByteString)payload);
                    if (req.getType().equals("Bearer ".trim())) {
                        try {
                            SessionService.TokenExpiration expiration;
                            UUID uuid = UuidCreator.fromString((String)req.getPayload().toString(StandardCharsets.US_ASCII));
                            SessionState session = FlightServiceGrpcImpl.this.sessionService.getSessionForToken(uuid);
                            if (session != null && (expiration = session.getExpiration()) != null) {
                                this.respondWithAuthTokenBin(expiration);
                            }
                            return;
                        }
                        catch (InvalidUuidException | IllegalArgumentException throwable) {
                            // empty catch block
                        }
                    }
                    auth = this.login(req.getType(), protocolVersion, req.getPayload(), handshakeResponseListener);
                }
            }
            catch (InvalidProtocolBufferException | AuthenticationException err) {
                log.error().append((CharSequence)"Authentication failed: ").append(err).endl();
                auth = Optional.empty();
            }
            if (auth.isEmpty()) {
                this.responseObserver.onError((Throwable)Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)"Authentication details invalid"));
                return;
            }
            SessionState session = FlightServiceGrpcImpl.this.sessionService.newSession((AuthContext)auth.get());
            this.respondWithAuthTokenBin(session.getExpiration());
        }

        private Optional<AuthContext> login(String type, long version, ByteString payload, AuthenticationRequestHandler.HandshakeResponseListener listener) throws AuthenticationException {
            AuthenticationRequestHandler handler = FlightServiceGrpcImpl.this.authRequestHandlers.get(type);
            if (handler == null) {
                log.info().append((CharSequence)"No AuthenticationRequestHandler registered for type ").append((CharSequence)type).endl();
                return Optional.empty();
            }
            return handler.login(version, payload.asReadOnlyByteBuffer(), listener);
        }

        private void respondWithAuthTokenBin(SessionService.TokenExpiration expiration) {
            this.isComplete = true;
            this.responseObserver.onNext((Object)Flight.HandshakeResponse.newBuilder().setPayload(expiration.getTokenAsByteString()).build());
            this.responseObserver.onCompleted();
        }

        public void onError(Throwable t) {
        }

        public void onCompleted() {
            if (this.isComplete) {
                return;
            }
            this.responseObserver.onError((Throwable)Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)"no authentication details provided"));
        }
    }
}

