/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.arrow;

import dagger.Module;
import dagger.Provides;
import dagger.multibindings.ElementsIntoSet;
import io.deephaven.extensions.barrage.BarrageMessageWriter;
import io.deephaven.server.arrow.ExchangeMarshaller;
import io.deephaven.server.arrow.ExchangeRequestHandlerFactory;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.util.Scheduler;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@Module
public class ExchangeMarshallerModule {
    @Provides
    public static List<ExchangeMarshaller> sortMarshallersByPriority(@NotNull Set<ExchangeMarshaller> marshallers) {
        return marshallers.stream().sorted(Comparator.comparingInt(ExchangeMarshaller::priority)).collect(Collectors.toUnmodifiableList());
    }

    @Provides
    @ElementsIntoSet
    public static Set<ExchangeMarshaller> provideExchangeMarshallers(Scheduler scheduler, SessionService.ErrorTransformer errorTransformer, BarrageMessageWriter.Factory streamGeneratorFactory) {
        return ServiceLoader.load(Factory.class).stream().map(factory -> ((Factory)factory.get()).create(scheduler, errorTransformer, streamGeneratorFactory)).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    @Provides
    @ElementsIntoSet
    public static Set<ExchangeRequestHandlerFactory> provideRequestHandlers() {
        return ServiceLoader.load(ExchangeRequestHandlerFactory.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public static interface Factory {
        public ExchangeMarshaller create(Scheduler var1, SessionService.ErrorTransformer var2, BarrageMessageWriter.Factory var3);
    }
}

