/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.arrow;

import com.google.protobuf.Message;
import io.deephaven.flightjs.protocol.BrowserFlight;
import io.deephaven.flightjs.protocol.BrowserFlightServiceGrpc;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.server.arrow.FlightServiceGrpcImpl;
import io.deephaven.server.browserstreaming.BrowserStream;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.util.GrpcServiceOverrideBuilder;
import io.deephaven.server.util.PassthroughInputStreamMarshaller;
import io.deephaven.server.util.UnaryInputStreamMarshaller;
import io.grpc.BindableService;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.arrow.flight.impl.Flight;

@Singleton
public class BrowserFlightServiceGrpcBinding
implements BindableService {
    private static final Logger log = LoggerFactory.getLogger(BrowserFlightServiceGrpcBinding.class);
    private final FlightServiceGrpcImpl delegate;
    private final SessionService sessionService;

    @Inject
    public BrowserFlightServiceGrpcBinding(FlightServiceGrpcImpl service, SessionService sessionService) {
        this.delegate = service;
        this.sessionService = sessionService;
    }

    public ServerServiceDefinition bindService() {
        return GrpcServiceOverrideBuilder.newBuilder(new BrowserFlightServiceGrpc.BrowserFlightServiceImplBase(){}.bindService()).onBidiBrowserSupport(this.delegate::handshake, BrowserFlightServiceGrpc.getOpenHandshakeMethod(), BrowserFlightServiceGrpc.getNextHandshakeMethod(), ProtoUtils.marshaller((Message)Flight.HandshakeRequest.getDefaultInstance()), ProtoUtils.marshaller((Message)Flight.HandshakeResponse.getDefaultInstance()), ProtoUtils.marshaller((Message)BrowserFlight.BrowserNextResponse.getDefaultInstance()), BrowserStream.Mode.IN_ORDER, log, this.sessionService).onBidiBrowserSupport(this.delegate::doPutCustom, BrowserFlightServiceGrpc.getOpenDoPutMethod(), BrowserFlightServiceGrpc.getNextDoPutMethod(), UnaryInputStreamMarshaller.INSTANCE, ProtoUtils.marshaller((Message)Flight.PutResult.getDefaultInstance()), ProtoUtils.marshaller((Message)BrowserFlight.BrowserNextResponse.getDefaultInstance()), BrowserStream.Mode.IN_ORDER, log, this.sessionService).onBidiBrowserSupport(this.delegate::doExchangeCustom, BrowserFlightServiceGrpc.getOpenDoExchangeMethod(), BrowserFlightServiceGrpc.getNextDoExchangeMethod(), UnaryInputStreamMarshaller.INSTANCE, PassthroughInputStreamMarshaller.INSTANCE, ProtoUtils.marshaller((Message)BrowserFlight.BrowserNextResponse.getDefaultInstance()), BrowserStream.Mode.IN_ORDER, log, this.sessionService).build();
    }
}

