/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.arrow;

import io.deephaven.barrage.flatbuf.BarrageSnapshotRequest;
import io.deephaven.barrage.flatbuf.BarrageSubscriptionOptions;
import io.deephaven.barrage.flatbuf.BarrageSubscriptionRequest;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.extensions.barrage.util.BarrageProtoUtil;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.jetbrains.annotations.Nullable;

public class BarrageRequestHelpers {
    public static final int DEFAULT_MIN_UPDATE_INTERVAL_MS = Configuration.getInstance().getIntegerWithDefault("barrage.minUpdateInterval", 1000);

    @Nullable
    public static RowSet getViewport(BarrageSubscriptionRequest subscriptionRequest) {
        boolean hasViewport = subscriptionRequest.viewportVector() != null;
        return hasViewport ? BarrageProtoUtil.toRowSet((ByteBuffer)subscriptionRequest.viewportAsByteBuffer()) : null;
    }

    @Nullable
    public static BitSet getColumns(BarrageSubscriptionRequest subscriptionRequest) {
        boolean hasColumns = subscriptionRequest.columnsVector() != null;
        return hasColumns ? BitSet.valueOf(subscriptionRequest.columnsAsByteBuffer()) : null;
    }

    @Nullable
    public static RowSet getViewport(BarrageSnapshotRequest snapshotRequest) {
        boolean hasViewport = snapshotRequest.viewportVector() != null;
        return hasViewport ? BarrageProtoUtil.toRowSet((ByteBuffer)snapshotRequest.viewportAsByteBuffer()) : null;
    }

    @Nullable
    public static BitSet getColumns(BarrageSnapshotRequest snapshotRequest) {
        boolean hasColumns = snapshotRequest.columnsVector() != null;
        return hasColumns ? BitSet.valueOf(snapshotRequest.columnsAsByteBuffer()) : null;
    }

    public static long getMinUpdateIntervalMs(BarrageSubscriptionOptions options) {
        long minUpdateIntervalMs = options == null || options.minUpdateIntervalMs() == 0 ? (long)DEFAULT_MIN_UPDATE_INTERVAL_MS : (long)options.minUpdateIntervalMs();
        return minUpdateIntervalMs;
    }
}

