/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.appmode;

import com.google.protobuf.ByteStringAccess;
import com.google.rpc.Code;
import io.deephaven.appmode.ApplicationState;
import io.deephaven.appmode.Field;
import io.deephaven.base.string.EncodingInfo;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.flight.util.TicketRouterHelper;
import io.deephaven.proto.util.ApplicationTicketHelper;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.appmode.AppFieldId;
import io.deephaven.server.appmode.ApplicationStates;
import io.deephaven.server.auth.AuthorizationProvider;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.session.TicketResolverBase;
import io.deephaven.server.session.TicketRouter;
import io.grpc.StatusRuntimeException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.arrow.flight.impl.Flight;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ApplicationTicketResolver
extends TicketResolverBase
implements ApplicationStates {
    private final Map<String, ApplicationState> applicationMap = new ConcurrentHashMap<String, ApplicationState>();

    @Inject
    public ApplicationTicketResolver(AuthorizationProvider authProvider) {
        super(authProvider, (byte)97, "app");
    }

    @Override
    public final Optional<ApplicationState> getApplicationState(String applicationId) {
        return Optional.ofNullable(this.applicationMap.get(applicationId));
    }

    public synchronized void onApplicationLoad(ApplicationState app) {
        if (this.applicationMap.containsKey(app.id())) {
            if (this.applicationMap.get(app.id()) != app) {
                throw new IllegalArgumentException("Duplicate application found for app_id " + app.id());
            }
            return;
        }
        this.applicationMap.put(app.id(), app);
    }

    @Override
    public <T> SessionState.ExportObject<T> resolve(@Nullable SessionState session, ByteBuffer ticket, String logId) {
        return this.resolve(this.appFieldIdFor(ticket, logId), logId);
    }

    @Override
    public <T> SessionState.ExportObject<T> resolve(@Nullable SessionState session, Flight.FlightDescriptor descriptor, String logId) {
        return this.resolve(this.appFieldIdFor(descriptor, logId), logId);
    }

    private <T> SessionState.ExportObject<T> resolve(AppFieldId id, String logId) {
        if (id.app == null) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': field '" + this.getLogNameFor(id) + "' does not belong to an application"));
        }
        Field field = id.app.getField(id.fieldName);
        if (field == null) {
            throw this.newNotFoundSRE(logId, id);
        }
        Object value = this.authorization.transform(field.value());
        if (value == null) {
            throw this.newNotFoundSRE(logId, id);
        }
        return SessionState.wrapAsExport(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionState.ExportObject<Flight.FlightInfo> flightInfoFor(@Nullable SessionState session, Flight.FlightDescriptor descriptor, String logId) {
        Flight.FlightInfo info;
        AppFieldId id = this.appFieldIdFor(descriptor, logId);
        if (id.app == null) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': field does not belong to an application"));
        }
        ApplicationState applicationState = id.app;
        synchronized (applicationState) {
            Field field = id.app.getField(id.fieldName);
            if (field == null) {
                throw this.newNotFoundSRE(logId, id);
            }
            Object value = field.value();
            if (value instanceof Table) {
                value = this.authorization.transform(value);
            }
            if (!(value instanceof Table)) {
                throw this.newNotFoundSRE(logId, id);
            }
            info = TicketRouter.getFlightInfo((Table)value, descriptor, ApplicationTicketResolver.flightTicketForName(id.app, id.fieldName));
        }
        return SessionState.wrapAsExport(info);
    }

    @Override
    public <T> SessionState.ExportBuilder<T> publish(SessionState session, ByteBuffer ticket, String logId, Runnable onPublish) {
        throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not publish '" + logId + "': application tickets cannot be published to"));
    }

    @Override
    public <T> SessionState.ExportBuilder<T> publish(SessionState session, Flight.FlightDescriptor descriptor, String logId, Runnable onPublish) {
        throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not publish '" + logId + "': application flight descriptors cannot be published to"));
    }

    @Override
    public String getLogNameFor(ByteBuffer ticket, String logId) {
        return this.getLogNameFor(this.appFieldIdFor(ticket, logId));
    }

    private String getLogNameFor(AppFieldId id) {
        return "app/" + id.applicationId() + "/field/" + id.fieldName;
    }

    @Override
    public void forAllFlightInfo(@Nullable SessionState session, Consumer<Flight.FlightInfo> visitor) {
        this.applicationMap.values().forEach(app -> app.listFields().forEach(field -> {
            Object value = field.value();
            if (value instanceof Table) {
                value = this.authorization.transform(value);
            }
            if (value instanceof Table) {
                Flight.FlightInfo info = TicketRouter.getFlightInfo((Table)value, ApplicationTicketResolver.descriptorForName(app, field.name()), ApplicationTicketResolver.flightTicketForName(app, field.name()));
                visitor.accept(info);
            }
        }));
    }

    public static Ticket ticketForName(ApplicationState app, String name) {
        byte[] ticket = ApplicationTicketHelper.applicationFieldToBytes((String)app.id(), (String)name);
        return Ticket.newBuilder().setTicket(ByteStringAccess.wrap((byte[])ticket)).build();
    }

    public static Flight.Ticket flightTicketForName(ApplicationState app, String name) {
        byte[] ticket = ApplicationTicketHelper.applicationFieldToBytes((String)app.id(), (String)name);
        return Flight.Ticket.newBuilder().setTicket(ByteStringAccess.wrap((byte[])ticket)).build();
    }

    public static Flight.FlightDescriptor descriptorForName(ApplicationState app, String name) {
        return Flight.FlightDescriptor.newBuilder().setType(Flight.FlightDescriptor.DescriptorType.PATH).addAllPath((Iterable)ApplicationTicketHelper.applicationFieldToPath((String)app.id(), (String)name)).build();
    }

    @NotNull
    private StatusRuntimeException newNotFoundSRE(String logId, AppFieldId id) {
        return Exceptions.statusRuntimeException((Code)Code.NOT_FOUND, (String)("Could not resolve '" + logId + "': field '" + this.getLogNameFor(id) + "' not found"));
    }

    private AppFieldId appFieldIdFor(ByteBuffer ticket, String logId) {
        String ticketAsString;
        if (ticket == null) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': ticket not supplied"));
        }
        int initialLimit = ticket.limit();
        int initialPosition = ticket.position();
        CharsetDecoder decoder = EncodingInfo.UTF_8.getDecoder().reset();
        try {
            ticketAsString = decoder.decode(ticket).toString();
        }
        catch (CharacterCodingException e) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': failed to decode: " + e.getMessage()));
        }
        finally {
            ticket.position(initialPosition);
            ticket.limit(initialLimit);
        }
        int endOfRoute = ticketAsString.indexOf(47);
        int endOfAppId = ticketAsString.indexOf(47, endOfRoute + 1);
        int endOfFieldSegment = ticketAsString.indexOf(47, endOfAppId + 1);
        if (endOfAppId == -1 || endOfFieldSegment == -1) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': ticket does conform to expected format"));
        }
        String appId = ticketAsString.substring(endOfRoute + 1, endOfAppId);
        String fieldName = ticketAsString.substring(endOfFieldSegment + 1);
        ApplicationState app = this.applicationMap.get(appId);
        if (app == null) {
            throw Exceptions.statusRuntimeException((Code)Code.NOT_FOUND, (String)("Could not resolve '" + logId + "': no application exists with the identifier: " + appId));
        }
        return AppFieldId.from(app, fieldName);
    }

    private AppFieldId appFieldIdFor(Flight.FlightDescriptor descriptor, String logId) {
        if (descriptor == null) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': descriptor not supplied"));
        }
        if (descriptor.getType() != Flight.FlightDescriptor.DescriptorType.PATH) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': only flight paths are supported"));
        }
        if (descriptor.getPathCount() != 4) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': unexpected path length (found: " + TicketRouterHelper.getLogNameFor((Flight.FlightDescriptor)descriptor) + ", expected: 4)"));
        }
        String appId = descriptor.getPath(1);
        ApplicationState app = this.applicationMap.get(appId);
        if (app == null) {
            throw Exceptions.statusRuntimeException((Code)Code.NOT_FOUND, (String)("Could not resolve '" + logId + "': no application exists with the identifier: " + appId));
        }
        if (!descriptor.getPath(2).equals("field")) {
            throw Exceptions.statusRuntimeException((Code)Code.NOT_FOUND, (String)("Could not resolve '" + logId + "': path is not an application field"));
        }
        return AppFieldId.from(app, descriptor.getPath(3));
    }
}

