/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.appmode;

import com.google.rpc.Code;
import io.deephaven.appmode.ApplicationState;
import io.deephaven.appmode.Field;
import io.deephaven.engine.util.ScriptSession;
import io.deephaven.extensions.barrage.util.GrpcUtil;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.backplane.grpc.ApplicationServiceGrpc;
import io.deephaven.proto.backplane.grpc.FieldInfo;
import io.deephaven.proto.backplane.grpc.FieldsChangeUpdate;
import io.deephaven.proto.backplane.grpc.ListFieldsRequest;
import io.deephaven.proto.backplane.grpc.TypedTicket;
import io.deephaven.server.appmode.AppFieldId;
import io.deephaven.server.console.ConsoleServiceGrpcImpl;
import io.deephaven.server.object.TypeLookup;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.util.Scheduler;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class ApplicationServiceGrpcImpl
extends ApplicationServiceGrpc.ApplicationServiceImplBase
implements ScriptSession.Listener,
ApplicationState.Listener {
    private static final Logger log = LoggerFactory.getLogger(ApplicationServiceGrpcImpl.class);
    private static final String QUERY_SCOPE_DESCRIPTION = "query scope variable";
    private final Scheduler scheduler;
    private final SessionService sessionService;
    private final TypeLookup typeLookup;
    private final Set<Subscription> subscriptions = new LinkedHashSet<Subscription>();
    private final FieldUpdatePropagationJob propagationJob = new FieldUpdatePropagationJob();
    private final Map<AppFieldId, FieldInfo> known = new LinkedHashMap<AppFieldId, FieldInfo>();
    private final Map<AppFieldId, State> accumulated = new LinkedHashMap<AppFieldId, State>();

    @Inject
    public ApplicationServiceGrpcImpl(Scheduler scheduler, SessionService sessionService, TypeLookup typeLookup) {
        this.scheduler = scheduler;
        this.sessionService = sessionService;
        this.typeLookup = typeLookup;
    }

    public synchronized void onScopeChanges(ScriptSession scriptSession, ScriptSession.Changes changes) {
        if (ConsoleServiceGrpcImpl.REMOTE_CONSOLE_DISABLED || changes.isEmpty()) {
            return;
        }
        for (Map.Entry e : changes.removed.entrySet()) {
            this.remove(AppFieldId.fromScopeName((String)e.getKey()));
        }
        for (Map.Entry e : changes.updated.entrySet()) {
            this.update(AppFieldId.fromScopeName((String)e.getKey()), QUERY_SCOPE_DESCRIPTION, (String)e.getValue());
        }
        for (Map.Entry e : changes.created.entrySet()) {
            this.create(AppFieldId.fromScopeName((String)e.getKey()), QUERY_SCOPE_DESCRIPTION, (String)e.getValue());
        }
        this.schedulePropagationOrClearIncrementalState();
    }

    public synchronized void onRemoveField(ApplicationState app, Field<?> oldField) {
        this.remove(AppFieldId.from(app, oldField.name()));
        this.schedulePropagationOrClearIncrementalState();
    }

    public synchronized void onNewField(ApplicationState app, Field<?> field) {
        AppFieldId id = AppFieldId.from(app, field.name());
        String type = this.typeLookup.type(field.value()).orElse(null);
        this.create(id, field.description().orElse(null), type);
        this.schedulePropagationOrClearIncrementalState();
    }

    private void schedulePropagationOrClearIncrementalState() {
        if (!this.subscriptions.isEmpty()) {
            this.propagationJob.markUpdates();
        } else {
            this.propagateUpdates();
        }
    }

    private synchronized void propagateUpdates() {
        this.propagationJob.markRunning();
        Updater updater = new Updater();
        for (State state : this.accumulated.values()) {
            state.append(updater);
        }
        this.accumulated.clear();
        if (!updater.isEmpty() && !this.subscriptions.isEmpty()) {
            FieldsChangeUpdate update = updater.build();
            ArrayList<Subscription> toCancel = new ArrayList<Subscription>(this.subscriptions);
            toCancel.removeIf(s -> s.send(update));
            toCancel.forEach(Subscription::onCancel);
        }
    }

    public synchronized void listFields(@NotNull ListFieldsRequest request, @NotNull StreamObserver<FieldsChangeUpdate> responseObserver) {
        SessionState session = this.sessionService.getCurrentSession();
        Subscription subscription = new Subscription(session, responseObserver);
        this.propagateUpdates();
        FieldsChangeUpdate.Builder responseBuilder = FieldsChangeUpdate.newBuilder();
        for (FieldInfo fieldInfo : this.known.values()) {
            responseBuilder.addCreated(fieldInfo);
        }
        if (subscription.send(responseBuilder.build())) {
            this.subscriptions.add(subscription);
        } else {
            subscription.onCancel();
        }
    }

    synchronized void remove(Subscription sub) {
        if (this.subscriptions.remove(sub)) {
            sub.notifyObserverCancelled();
        }
    }

    private static TypedTicket typedTicket(AppFieldId id, String type) {
        TypedTicket.Builder ticket = TypedTicket.newBuilder().setTicket(id.getTicket());
        if (type != null) {
            ticket.setType(type);
        }
        return ticket.build();
    }

    private void create(AppFieldId id, String description, String type) {
        this.accumulated(id).create(description, type);
    }

    private void update(AppFieldId id, String description, String type) {
        this.accumulated(id).update(description, type);
    }

    private void remove(AppFieldId id) {
        this.accumulated(id).remove();
    }

    private State accumulated(AppFieldId id) {
        return this.accumulated.computeIfAbsent(id, this::newState);
    }

    private State newState(AppFieldId id) {
        FieldInfo existingInfo = this.known.get(id);
        return existingInfo == null ? State.emptyState(id) : State.existingState(id, existingInfo);
    }

    private class FieldUpdatePropagationJob
    implements Runnable {
        private static final long UPDATE_INTERVAL_MS = 250L;
        private long lastScheduledMillis = 0L;
        private boolean isScheduled = false;

        private FieldUpdatePropagationJob() {
        }

        @Override
        public void run() {
            try {
                ApplicationServiceGrpcImpl.this.propagateUpdates();
            }
            catch (Throwable t) {
                log.error(t).append((CharSequence)"failed to propagate field changes").endl();
            }
        }

        private void markRunning() {
            this.isScheduled = false;
        }

        private boolean markUpdates() {
            long nextMin;
            if (this.isScheduled) {
                return false;
            }
            this.isScheduled = true;
            long now = ApplicationServiceGrpcImpl.this.scheduler.currentTimeMillis();
            if (now >= (nextMin = this.lastScheduledMillis + 250L)) {
                this.lastScheduledMillis = now;
                ApplicationServiceGrpcImpl.this.scheduler.runImmediately(this);
            } else {
                this.lastScheduledMillis = nextMin;
                ApplicationServiceGrpcImpl.this.scheduler.runAfterDelay(nextMin - now, this);
            }
            return true;
        }
    }

    private class Updater {
        private final FieldsChangeUpdate.Builder builder = FieldsChangeUpdate.newBuilder();
        private boolean isEmpty = true;

        private Updater() {
        }

        boolean isEmpty() {
            return this.isEmpty;
        }

        void onCreated(AppFieldId id, FieldInfo info) {
            this.builder.addCreated(info);
            ApplicationServiceGrpcImpl.this.known.put(id, info);
            this.isEmpty = false;
        }

        void onUpdated(AppFieldId id, FieldInfo info) {
            this.builder.addUpdated(info);
            ApplicationServiceGrpcImpl.this.known.put(id, info);
            this.isEmpty = false;
        }

        void onRemoved(AppFieldId id, FieldInfo info) {
            this.builder.addRemoved(info);
            ApplicationServiceGrpcImpl.this.known.remove(id);
            this.isEmpty = false;
        }

        FieldsChangeUpdate build() {
            return this.builder.build();
        }
    }

    private static class State {
        private final AppFieldId id;
        private final FieldInfo existing;
        private String description;
        private String type;
        private CUR out;

        public static State emptyState(AppFieldId id) {
            return new State(id, null);
        }

        public static State existingState(AppFieldId id, FieldInfo existing) {
            return new State(id, Objects.requireNonNull(existing));
        }

        private State(AppFieldId id, FieldInfo existing) {
            this.id = Objects.requireNonNull(id);
            this.existing = existing;
            this.out = existing == null ? CUR.NOOP : CUR.UPDATED;
        }

        public void create(String description, String type) {
            if (this.existing == null) {
                this.transition(CUR.NOOP, CUR.CREATED);
            } else {
                this.transition(CUR.REMOVED, CUR.UPDATED);
            }
            this.description = description;
            this.type = type;
        }

        public void update(String description, String type) {
            if (this.existing == null) {
                this.check(CUR.CREATED);
            } else {
                this.check(CUR.UPDATED);
            }
            this.description = description;
            this.type = type;
        }

        public void remove() {
            if (this.existing == null) {
                this.transition(CUR.CREATED, CUR.NOOP);
            } else {
                this.transition(CUR.UPDATED, CUR.REMOVED);
            }
            this.description = null;
            this.type = null;
        }

        public void append(Updater updater) {
            switch (this.out.ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    updater.onCreated(this.id, this.fieldInfo());
                    break;
                }
                case 2: {
                    updater.onUpdated(this.id, this.fieldInfo());
                    break;
                }
                case 3: {
                    updater.onRemoved(this.id, Objects.requireNonNull(this.existing));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected state " + String.valueOf((Object)this.out));
                }
            }
        }

        private void transition(CUR from, CUR to) {
            if (this.out != from) {
                throw new IllegalStateException(String.format("Expected transition from=%s to=%s, actual=%s", new Object[]{from, to, this.out}));
            }
            this.out = to;
        }

        private void check(CUR expected) {
            if (this.out != expected) {
                throw new IllegalStateException(String.format("Expected state=%s, actual=%s", new Object[]{expected, this.out}));
            }
        }

        private FieldInfo fieldInfo() {
            return FieldInfo.newBuilder().setTypedTicket(ApplicationServiceGrpcImpl.typedTicket(this.id, this.type)).setFieldName(this.id.fieldName).setFieldDescription(this.description == null ? "" : this.description).setApplicationId(this.id.applicationId()).setApplicationName(this.id.applicationName()).build();
        }
    }

    private class Subscription
    implements Closeable {
        private final SessionState session;
        private final StreamObserver<FieldsChangeUpdate> observer;

        public Subscription(SessionState session, StreamObserver<FieldsChangeUpdate> observer) {
            this.session = session;
            this.observer = observer;
            if (observer instanceof ServerCallStreamObserver) {
                ServerCallStreamObserver serverCall = (ServerCallStreamObserver)observer;
                serverCall.setOnCancelHandler(this::onCancel);
            }
            session.addOnCloseCallback(this);
        }

        void onCancel() {
            if (this.session.removeOnCloseCallback(this)) {
                this.close();
            }
        }

        @Override
        public void close() {
            ApplicationServiceGrpcImpl.this.remove(this);
        }

        private boolean send(FieldsChangeUpdate changes) {
            try {
                this.observer.onNext((Object)changes);
            }
            catch (RuntimeException ignored) {
                return false;
            }
            return true;
        }

        private void notifyObserverCancelled() {
            GrpcUtil.safelyError(this.observer, (Code)Code.CANCELLED, (String)"subscription cancelled");
        }
    }

    private static enum CUR {
        NOOP,
        CREATED,
        UPDATED,
        REMOVED;

    }
}

