/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.appmode;

import io.deephaven.appmode.ApplicationConfig;
import io.deephaven.appmode.ApplicationState;
import io.deephaven.engine.liveness.LivenessScopeStack;
import io.deephaven.engine.util.ScriptSession;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.server.appmode.ApplicationFactory;
import io.deephaven.server.appmode.ApplicationTicketResolver;
import io.deephaven.util.SafeCloseable;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;

public class ApplicationInjector {
    private static final Logger log = LoggerFactory.getLogger(ApplicationInjector.class);
    private final Provider<ScriptSession> scriptSessionProvider;
    private final ApplicationTicketResolver ticketResolver;
    private final ApplicationState.Listener applicationListener;
    private final Set<ApplicationState.Factory> factories;

    @Inject
    public ApplicationInjector(Provider<ScriptSession> scriptSessionProvider, ApplicationTicketResolver ticketResolver, ApplicationState.Listener applicationListener, Set<ApplicationState.Factory> factories) {
        this.scriptSessionProvider = Objects.requireNonNull(scriptSessionProvider);
        this.ticketResolver = ticketResolver;
        this.applicationListener = applicationListener;
        this.factories = factories;
    }

    public void run() throws IOException, ClassNotFoundException {
        List<ApplicationConfig> configs;
        for (ApplicationState.Factory factory : this.factories) {
            this.loadApplicationFactory(factory);
        }
        if (!ApplicationConfig.isCustomApplicationModeEnabled()) {
            return;
        }
        Path applicationDir = ApplicationConfig.customApplicationDir();
        log.info().append((CharSequence)"Finding custom application(s) in '").append((CharSequence)applicationDir.toString()).append((CharSequence)"'...").endl();
        try {
            configs = ApplicationConfig.find();
        }
        catch (NoSuchFileException ignored) {
            configs = Collections.emptyList();
        }
        catch (RuntimeException error) {
            log.error().append((CharSequence)"Failed to read custom application config(s): ").append((Throwable)error).endl();
            throw error;
        }
        if (configs.isEmpty()) {
            log.warn().append((CharSequence)"No custom application(s) found...").endl();
            return;
        }
        for (ApplicationConfig config : configs) {
            if (!config.isEnabled()) {
                log.info().append((CharSequence)"Skipping disabled custom application: ").append((CharSequence)config.toString()).endl();
                continue;
            }
            this.loadApplication(applicationDir, config);
        }
    }

    private void loadApplication(Path applicationDir, ApplicationConfig config) {
        ApplicationState app;
        log.info().append((CharSequence)"Starting application '").append((CharSequence)config.toString()).append('\'').endl();
        try (SafeCloseable ignored = LivenessScopeStack.open();
             SafeCloseable ignored2 = ((ScriptSession)this.scriptSessionProvider.get()).getExecutionContext().open();){
            app = ApplicationFactory.create(applicationDir, config, (ScriptSession)this.scriptSessionProvider.get(), this.applicationListener);
        }
        int numExports = app.listFields().size();
        log.info().append((CharSequence)"\tfound ").append(numExports).append((CharSequence)" exports").endl();
        this.ticketResolver.onApplicationLoad(app);
    }

    private void loadApplicationFactory(ApplicationState.Factory factory) {
        ApplicationState app;
        log.info().append((CharSequence)"Starting ApplicationState.Factory '").append((CharSequence)factory.toString()).append('\'').endl();
        try (SafeCloseable ignored1 = LivenessScopeStack.open();
             SafeCloseable ignored2 = ((ScriptSession)this.scriptSessionProvider.get()).getExecutionContext().open();){
            app = factory.create(this.applicationListener);
        }
        int numExports = app.listFields().size();
        log.info().append((CharSequence)"\tapp.id=").append((CharSequence)app.id()).append((CharSequence)", found ").append(numExports).append((CharSequence)" exports").endl();
        this.ticketResolver.onApplicationLoad(app);
    }
}

