/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.appmode;

import com.google.rpc.Code;
import io.deephaven.appmode.ApplicationConfig;
import io.deephaven.appmode.ApplicationContext;
import io.deephaven.appmode.ApplicationState;
import io.deephaven.appmode.DynamicApplication;
import io.deephaven.appmode.QSTApplication;
import io.deephaven.appmode.ScriptApplication;
import io.deephaven.appmode.StaticClassApplication;
import io.deephaven.engine.util.GroovyDeephavenSession;
import io.deephaven.engine.util.ScriptSession;
import io.deephaven.integrations.python.PythonDeephavenSession;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.appmode.ScriptApplicationState;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public class ApplicationFactory
implements ApplicationConfig.Visitor {
    private final Path applicationDir;
    private final ScriptSession scriptSession;
    private final ApplicationState.Listener appStateListener;
    private ApplicationState out;

    public static ApplicationState create(Path applicationDir, ApplicationConfig config, ScriptSession scriptSession, ApplicationState.Listener appStateListener) {
        return ((ApplicationFactory)config.walk((ApplicationConfig.Visitor)new ApplicationFactory(applicationDir, scriptSession, appStateListener))).out();
    }

    private ApplicationFactory(Path applicationDir, ScriptSession scriptSession, ApplicationState.Listener appStateListener) {
        this.applicationDir = Objects.requireNonNull(applicationDir);
        this.scriptSession = scriptSession;
        this.appStateListener = appStateListener;
    }

    public ApplicationState out() {
        return Objects.requireNonNull(this.out);
    }

    public void visit(ScriptApplication app) {
        if (app.scriptType().equals("groovy")) {
            if (!(this.scriptSession instanceof GroovyDeephavenSession)) {
                throw new IllegalArgumentException(String.format("Cannot instantiate Groovy application on a %s app session", this.scriptSession.scriptType()));
            }
        } else if (app.scriptType().equals("python")) {
            if (!(this.scriptSession instanceof PythonDeephavenSession)) {
                throw new IllegalArgumentException(String.format("Cannot instantiate Python application on a %s app session", this.scriptSession.scriptType()));
            }
        } else {
            throw new UnsupportedOperationException(String.format("Currently do not support script sessions of type '%s'", app.scriptType()));
        }
        this.out = new ScriptApplicationState(this.scriptSession, this.appStateListener, app.id(), app.name());
        ApplicationContext.runUnderContext((ApplicationState)this.out, () -> this.evaluateScripts(app.files()));
    }

    public void visit(DynamicApplication<?> advanced) {
        try {
            this.out = advanced.create(this.appStateListener);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(QSTApplication qst) {
        throw Exceptions.statusRuntimeException((Code)Code.UNIMPLEMENTED, (String)"See deephaven-core#1080; support qst application");
    }

    public void visit(StaticClassApplication<?> clazz) {
        try {
            this.out = clazz.create().toState(this.appStateListener);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private Path absolutePath(Path path) {
        return path.isAbsolute() ? path : this.applicationDir.resolve(path);
    }

    private void evaluateScripts(List<Path> files) {
        for (Path file : files) {
            this.scriptSession.evaluateScript(this.absolutePath(file)).throwIfError();
        }
    }
}

