/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.appmode;

import com.google.common.base.Objects;
import io.deephaven.appmode.ApplicationState;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.server.appmode.ApplicationTicketResolver;
import io.deephaven.server.console.ScopeTicketResolver;
import org.jetbrains.annotations.Nullable;

public class AppFieldId {
    private static final String SCOPE_ID = "scope";
    final ApplicationState app;
    final String fieldName;

    static AppFieldId from(ApplicationState app, String fieldName) {
        return new AppFieldId(app, fieldName);
    }

    public static AppFieldId fromScopeName(String fieldName) {
        return new AppFieldId(null, fieldName);
    }

    private AppFieldId(@Nullable ApplicationState app, String fieldName) {
        this.app = app;
        if (this.app != null && this.app.id().equals(SCOPE_ID)) {
            throw new IllegalArgumentException(String.format("Applications cannot re-use the id '%s'; it is reserved for QueryScope use only", SCOPE_ID));
        }
        this.fieldName = fieldName;
    }

    public Ticket getTicket() {
        if (this.app == null) {
            return ScopeTicketResolver.ticketForName(this.fieldName);
        }
        return ApplicationTicketResolver.ticketForName(this.app, this.fieldName);
    }

    public String applicationId() {
        return this.app == null ? SCOPE_ID : this.app.id();
    }

    public String applicationName() {
        return this.app == null ? "" : this.app.name();
    }

    public String toString() {
        return "AppFieldId{appId=" + (this.app == null ? "" : this.app.id()) + ", fieldName=" + this.fieldName + "}";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.app == null ? null : this.app.id(), this.fieldName});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppFieldId fid = (AppFieldId)o;
        return this.app == fid.app && this.fieldName.equals(fid.fieldName);
    }
}

