/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.time.calendar;

import io.deephaven.hash.KeyedIntObjectHash;
import io.deephaven.hash.KeyedIntObjectKey;
import java.util.function.IntFunction;

class ReadOptimizedConcurrentCache<V extends IntKeyedValue> {
    private final IntFunction<V> valueComputer;
    private final KeyedIntObjectHash<V> cache;

    public ReadOptimizedConcurrentCache(int initialCapacity, IntFunction<V> valueComputer) {
        this.valueComputer = valueComputer;
        this.cache = new KeyedIntObjectHash(initialCapacity, new KeyDef());
    }

    synchronized void clear() {
        this.cache.clear();
    }

    public V computeIfAbsent(int key) {
        IntKeyedValue existing = (IntKeyedValue)this.cache.get(key);
        if (existing != null) {
            return (V)existing;
        }
        IntKeyedValue newValue = (IntKeyedValue)this.valueComputer.apply(key);
        if (newValue == null) {
            throw new NullPointerException("Computed a null value: key=" + key);
        }
        this.cache.put(key, (Object)newValue);
        return (V)newValue;
    }

    private static class KeyDef<V extends IntKeyedValue>
    extends KeyedIntObjectKey.BasicStrict<V> {
        private KeyDef() {
        }

        public int getIntKey(V v) {
            return ((IntKeyedValue)v).getKey();
        }
    }

    public static abstract class IntKeyedValue {
        private final int key;

        public IntKeyedValue(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }
    }

    public static class Pair<T>
    extends IntKeyedValue {
        private final T value;

        public Pair(int key, T value) {
            super(key);
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }
}

