/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.time.calendar;

import io.deephaven.api.util.NameValidator;
import io.deephaven.base.verify.Require;
import io.deephaven.configuration.Configuration;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.time.calendar.BusinessCalendar;
import io.deephaven.time.calendar.BusinessCalendarXMLParser;
import io.deephaven.time.calendar.Calendar;
import io.deephaven.util.annotations.UserInvocationPermitted;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

@UserInvocationPermitted(value={"function_library"})
public class Calendars {
    private static final Logger logger = LoggerFactory.getLogger(Calendars.class);
    private static final String BUSINESS_CALENDAR_PROP_INTERNAL = "Calendar.importPath";
    private static final String BUSINESS_CALENDAR_PROP_USER = "Calendar.userImportPath";
    private static String defaultName = Configuration.getInstance().getProperty("Calendar.default");
    private static final Map<String, BusinessCalendar> calMap = new TreeMap<String, BusinessCalendar>();

    public static List<BusinessCalendar> calendarsFromConfiguration() {
        Configuration configuration = Configuration.getInstance();
        ArrayList<BusinessCalendar> configurationCalendars = new ArrayList<BusinessCalendar>(Calendars.loadCalendarsFromResourceList(configuration.getProperty(BUSINESS_CALENDAR_PROP_INTERNAL)));
        if (configuration.hasProperty(BUSINESS_CALENDAR_PROP_USER)) {
            configurationCalendars.addAll(Calendars.loadCalendarsFromResourceList(configuration.getProperty(BUSINESS_CALENDAR_PROP_USER)));
        }
        return configurationCalendars;
    }

    private Calendars() {
    }

    private static List<BusinessCalendar> loadCalendarsFromResourceList(String resource) {
        ArrayList<BusinessCalendar> arrayList;
        InputStream in = Calendars.class.getResourceAsStream(resource);
        if (in == null) {
            logger.warn((Object)("Could not find resource " + resource + " on classpath"));
            throw new RuntimeException("Could not open resource " + resource + " from classpath");
        }
        ArrayList<BusinessCalendar> calendars = new ArrayList<BusinessCalendar>();
        BufferedReader config = new BufferedReader(new InputStreamReader(in));
        try {
            Iterator it = config.lines().iterator();
            while (it.hasNext()) {
                String calendarResource = (String)it.next();
                calendars.add(BusinessCalendarXMLParser.loadBusinessCalendarFromResource(calendarResource));
            }
            arrayList = calendars;
        }
        catch (Throwable throwable) {
            try {
                try {
                    config.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.warn((Object)("Problem loading calendar: location=" + resource), (Throwable)e);
                throw new RuntimeException("Problem loading calendar: location=" + resource, e);
            }
        }
        config.close();
        return arrayList;
    }

    public static synchronized void removeCalendar(String name) {
        Require.neqNull((Object)name, (String)"name");
        calMap.remove(name);
    }

    public static synchronized void addCalendar(BusinessCalendar cal) {
        Require.neqNull((Object)cal, (String)"cal");
        String name = cal.name().toUpperCase();
        if (!NameValidator.isValidQueryParameterName((String)name)) {
            throw new IllegalArgumentException("Invalid name for calendar: name='" + name + "'");
        }
        Map<String, BusinessCalendar> map = calMap;
        if (map.containsKey(name)) {
            Calendar oldCalendar = map.get(name);
            if (oldCalendar.equals(cal)) {
                return;
            }
            throw new IllegalArgumentException("Multiple calendars have the same name: name='" + name + "'");
        }
        map.put(name, cal);
    }

    public static void addCalendarFromFile(String file) {
        Require.neqNull((Object)file, (String)"file");
        Calendars.addCalendarFromFile(new File(file));
    }

    public static void addCalendarFromFile(File file) {
        Require.neqNull((Object)file, (String)"file");
        if (!file.getAbsolutePath().endsWith(".calendar")) {
            throw new UnsupportedOperationException("Calendar file must be in .calendar format");
        }
        BusinessCalendar cal = BusinessCalendarXMLParser.loadBusinessCalendar(file);
        Calendars.addCalendar(cal);
    }

    private static File inputStreamToFile(@NotNull InputStream inputStream) throws IOException {
        int read;
        File calendarFile = File.createTempFile("temp-file-name", ".calendar");
        FileOutputStream outputStream = new FileOutputStream(calendarFile);
        byte[] bytes = new byte[1024];
        while ((read = inputStream.read(bytes)) != -1) {
            outputStream.write(bytes, 0, read);
        }
        outputStream.close();
        return calendarFile;
    }

    public static synchronized void setCalendar(String name) {
        Require.neqNull((Object)name, (String)"name");
        defaultName = name;
    }

    public static synchronized BusinessCalendar calendar(String name) {
        if (name == null) {
            return null;
        }
        Map<String, BusinessCalendar> map = calMap;
        String n = name.toUpperCase();
        if (!map.containsKey(n)) {
            throw new IllegalArgumentException("No such calendar: " + name);
        }
        return map.get(n);
    }

    public static synchronized BusinessCalendar calendar() {
        return Calendars.calendar(defaultName);
    }

    public static synchronized String calendarName() {
        return defaultName;
    }

    public static synchronized String[] calendarNames() {
        return (String[])calMap.keySet().toArray(String[]::new);
    }
}

