/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.time.calendar;

import io.deephaven.base.verify.Require;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.time.calendar.ReadOptimizedConcurrentCache;
import io.deephaven.time.calendar.YearMonthSummaryCache;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Calendar {
    private final String name;
    private final String description;
    private final ZoneId timeZone;
    private final YearMonthSummaryCache<SummaryData> summaryCache = new YearMonthSummaryCache<SummaryData>(this::computeMonthSummary, this::computeYearSummary);

    private SummaryData summarize(int key, LocalDate startDate, LocalDate endDate) {
        LocalDate date = startDate;
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        while (date.isBefore(endDate)) {
            dates.add(date);
            date = date.plusDays(1L);
        }
        return new SummaryData(key, startDate, endDate, dates);
    }

    private SummaryData computeMonthSummary(int yearMonth) {
        int year = YearMonthSummaryCache.yearFromYearMonthKey(yearMonth);
        int month = YearMonthSummaryCache.monthFromYearMonthKey(yearMonth);
        LocalDate startDate = LocalDate.of(year, month, 1);
        LocalDate endDate = startDate.plusMonths(1L);
        return this.summarize(yearMonth, startDate, endDate);
    }

    private SummaryData computeYearSummary(int year) {
        LocalDate startDate = null;
        LocalDate endDate = null;
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        for (int month = 1; month <= 12; ++month) {
            SummaryData ms = this.summaryCache.getMonthSummary(year, month);
            if (month == 1) {
                startDate = ms.startDate;
            }
            if (month == 12) {
                endDate = ms.endDate;
            }
            dates.addAll(ms.dates);
        }
        return new SummaryData(year, startDate, endDate, dates);
    }

    Calendar(String name, String description, ZoneId timeZone) {
        this.name = (String)Require.neqNull((Object)name, (String)"name");
        this.description = description;
        this.timeZone = (ZoneId)Require.neqNull((Object)timeZone, (String)"timeZone");
    }

    synchronized void clearCache() {
        this.summaryCache.clear();
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public ZoneId timeZone() {
        return this.timeZone;
    }

    public String toString() {
        return "Calendar{name='" + this.name + "', description='" + this.description + "', timeZone=" + String.valueOf(this.timeZone) + "}";
    }

    public LocalDate calendarDate() {
        return DateTimeUtils.todayLocalDate(this.timeZone());
    }

    public DayOfWeek dayOfWeek() {
        return this.dayOfWeek(this.calendarDate());
    }

    public DayOfWeek dayOfWeek(LocalDate date) {
        return DateTimeUtils.dayOfWeek(date);
    }

    public DayOfWeek dayOfWeek(String date) {
        if (date == null) {
            return null;
        }
        return DateTimeUtils.dayOfWeek(DateTimeUtils.parseLocalDate(date));
    }

    public DayOfWeek dayOfWeek(Instant time) {
        if (time == null) {
            return null;
        }
        return DateTimeUtils.dayOfWeek(time, this.timeZone);
    }

    public DayOfWeek dayOfWeek(ZonedDateTime time) {
        if (time == null) {
            return null;
        }
        return DateTimeUtils.dayOfWeek(time.toInstant(), this.timeZone);
    }

    public int dayOfWeekValue() {
        return this.dayOfWeekValue(this.calendarDate());
    }

    public int dayOfWeekValue(LocalDate date) {
        if (date == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.dayOfWeekValue(date);
    }

    public int dayOfWeekValue(String date) {
        if (date == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.dayOfWeekValue(DateTimeUtils.parseLocalDate(date));
    }

    public int dayOfWeekValue(Instant time) {
        if (time == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.dayOfWeekValue(time, this.timeZone);
    }

    public int dayOfWeekValue(ZonedDateTime time) {
        if (time == null) {
            return Integer.MIN_VALUE;
        }
        return DateTimeUtils.dayOfWeekValue(time.toInstant(), this.timeZone);
    }

    public LocalDate plusDays(LocalDate date, int days) {
        if (date == null || days == Integer.MIN_VALUE) {
            return null;
        }
        return date.plusDays(days);
    }

    public String plusDays(String date, int days) {
        if (date == null || days == Integer.MIN_VALUE) {
            return null;
        }
        LocalDate d = this.plusDays(DateTimeUtils.parseLocalDate(date), days);
        return d == null ? null : d.toString();
    }

    public Instant plusDays(Instant time, int days) {
        if (time == null || days == Integer.MIN_VALUE) {
            return null;
        }
        return this.plusDays(DateTimeUtils.toZonedDateTime(time, this.timeZone), days).toInstant();
    }

    public ZonedDateTime plusDays(ZonedDateTime time, int days) {
        if (time == null || days == Integer.MIN_VALUE) {
            return null;
        }
        ZonedDateTime zdt = time.withZoneSameInstant(this.timeZone);
        return this.plusDays(zdt.toLocalDate(), days).atTime(zdt.toLocalTime()).atZone(this.timeZone);
    }

    public LocalDate minusDays(LocalDate date, int days) {
        if (date == null || days == Integer.MIN_VALUE) {
            return null;
        }
        return date.minusDays(days);
    }

    public String minusDays(String date, int days) {
        if (date == null || days == Integer.MIN_VALUE) {
            return null;
        }
        LocalDate d = this.minusDays(DateTimeUtils.parseLocalDate(date), days);
        return d == null ? null : d.toString();
    }

    public Instant minusDays(Instant time, int days) {
        if (time == null || days == Integer.MIN_VALUE) {
            return null;
        }
        return this.plusDays(time, -days);
    }

    public ZonedDateTime minusDays(ZonedDateTime time, int days) {
        if (time == null || days == Integer.MIN_VALUE) {
            return null;
        }
        return this.plusDays(time, -days);
    }

    public LocalDate futureDate(int days) {
        return this.plusDays(this.calendarDate(), days);
    }

    public LocalDate pastDate(int days) {
        return this.minusDays(this.calendarDate(), days);
    }

    private void calendarDatesInternal(ArrayList<LocalDate> result, LocalDate start, LocalDate end, boolean startInclusive, boolean endInclusive) {
        LocalDate day = start;
        while (!day.isAfter(end)) {
            boolean skip;
            boolean bl = skip = !startInclusive && day.equals(start) || !endInclusive && day.equals(end);
            if (!skip) {
                result.add(day);
            }
            day = day.plusDays(1L);
        }
    }

    public LocalDate[] calendarDates(LocalDate start, LocalDate end, boolean startInclusive, boolean endInclusive) {
        if (start == null || end == null) {
            return null;
        }
        if (start.isAfter(end)) {
            return new LocalDate[0];
        }
        ArrayList<LocalDate> dateList = new ArrayList<LocalDate>();
        SummaryData summaryFirst = null;
        SummaryData summary = null;
        Iterator<SummaryData> it = this.summaryCache.iterator(start, end, startInclusive, endInclusive);
        while (it.hasNext()) {
            summary = it.next();
            if (summaryFirst == null) {
                summaryFirst = summary;
                this.calendarDatesInternal(dateList, start, summaryFirst.startDate, startInclusive, false);
            }
            dateList.addAll(summary.dates);
        }
        if (summaryFirst == null) {
            this.calendarDatesInternal(dateList, start, end, startInclusive, endInclusive);
        } else {
            this.calendarDatesInternal(dateList, summary.endDate, end, true, endInclusive);
        }
        return dateList.toArray(new LocalDate[0]);
    }

    public String[] calendarDates(String start, String end, boolean startInclusive, boolean endInclusive) {
        if (start == null || end == null) {
            return null;
        }
        LocalDate[] dates = this.calendarDates(DateTimeUtils.parseLocalDate(start), DateTimeUtils.parseLocalDate(end), startInclusive, endInclusive);
        return dates == null ? null : (String[])Arrays.stream(dates).map(DateTimeUtils::formatDate).toArray(String[]::new);
    }

    public LocalDate[] calendarDates(ZonedDateTime start, ZonedDateTime end, boolean startInclusive, boolean endInclusive) {
        if (start == null || end == null) {
            return null;
        }
        return this.calendarDates(start.withZoneSameInstant(this.timeZone).toLocalDate(), end.withZoneSameInstant(this.timeZone).toLocalDate(), startInclusive, endInclusive);
    }

    public LocalDate[] calendarDates(Instant start, Instant end, boolean startInclusive, boolean endInclusive) {
        if (start == null || end == null) {
            return null;
        }
        return this.calendarDates(DateTimeUtils.toLocalDate(start, this.timeZone), DateTimeUtils.toLocalDate(end, this.timeZone), startInclusive, endInclusive);
    }

    public LocalDate[] calendarDates(LocalDate start, LocalDate end) {
        return this.calendarDates(start, end, true, true);
    }

    public String[] calendarDates(String start, String end) {
        return this.calendarDates(start, end, true, true);
    }

    public LocalDate[] calendarDates(ZonedDateTime start, ZonedDateTime end) {
        return this.calendarDates(start, end, true, true);
    }

    public LocalDate[] calendarDates(Instant start, Instant end) {
        return this.calendarDates(start, end, true, true);
    }

    public int numberCalendarDates(LocalDate start, LocalDate end, boolean startInclusive, boolean endInclusive) {
        if (start == null || end == null) {
            return Integer.MIN_VALUE;
        }
        int days = (int)ChronoUnit.DAYS.between(start, end.plusDays(1L));
        if (!startInclusive) {
            --days;
        }
        if (!endInclusive) {
            --days;
        }
        return Math.max(days, 0);
    }

    public int numberCalendarDates(String start, String end, boolean startInclusive, boolean endInclusive) {
        if (start == null || end == null) {
            return Integer.MIN_VALUE;
        }
        return this.numberCalendarDates(DateTimeUtils.parseLocalDate(start), DateTimeUtils.parseLocalDate(end), startInclusive, endInclusive);
    }

    public int numberCalendarDates(ZonedDateTime start, ZonedDateTime end, boolean startInclusive, boolean endInclusive) {
        if (start == null || end == null) {
            return Integer.MIN_VALUE;
        }
        return this.numberCalendarDates(start.withZoneSameInstant(this.timeZone).toLocalDate(), end.withZoneSameInstant(this.timeZone).toLocalDate(), startInclusive, endInclusive);
    }

    public int numberCalendarDates(Instant start, Instant end, boolean startInclusive, boolean endInclusive) {
        if (start == null || end == null) {
            return Integer.MIN_VALUE;
        }
        return this.numberCalendarDates(DateTimeUtils.toLocalDate(start, this.timeZone), DateTimeUtils.toLocalDate(end, this.timeZone), startInclusive, endInclusive);
    }

    public int numberCalendarDates(LocalDate start, LocalDate end) {
        return this.numberCalendarDates(start, end, true, true);
    }

    public int numberCalendarDates(String start, String end) {
        return this.numberCalendarDates(start, end, true, true);
    }

    public int numberCalendarDates(ZonedDateTime start, ZonedDateTime end) {
        return this.numberCalendarDates(start, end, true, true);
    }

    public int numberCalendarDates(Instant start, Instant end) {
        return this.numberCalendarDates(start, end, true, true);
    }

    private static class SummaryData
    extends ReadOptimizedConcurrentCache.IntKeyedValue {
        final LocalDate startDate;
        final LocalDate endDate;
        final List<LocalDate> dates;

        SummaryData(int key, LocalDate startDate, LocalDate endDate, List<LocalDate> dates) {
            super(key);
            this.startDate = startDate;
            this.endDate = endDate;
            this.dates = dates;
        }
    }
}

