/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.time;

import io.deephaven.base.verify.Require;
import io.deephaven.configuration.Configuration;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TimeZoneAliases {
    private static final Logger logger = LoggerFactory.getLogger(TimeZoneAliases.class);
    private static final Cache INSTANCE = TimeZoneAliases.load("timezone.aliases");

    private static Reader propertyToReader(String property) {
        Require.neqNull((Object)property, (String)"property");
        String location = Configuration.getInstance().getProperty(property);
        try {
            return new FileReader(location);
        }
        catch (FileNotFoundException fileNotFoundException) {
            InputStream stream = TimeZoneAliases.class.getResourceAsStream(location);
            if (stream != null) {
                return new InputStreamReader(stream);
            }
            logger.error((Object)("Unable to open time zone alias property file: property=" + property + " location=" + location));
            throw new RuntimeException("Unable to open time zone alias property file: property=" + property + " location=" + location);
        }
    }

    private static Cache load(String property) {
        Cache cache = new Cache();
        String location = Configuration.getInstance().getStringWithDefault(property, null);
        try (BufferedReader br = new BufferedReader(TimeZoneAliases.propertyToReader(property));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.startsWith("//") || line.isBlank()) continue;
                Object[] values = line.split(",");
                if (values.length == 2) {
                    cache.addAlias(values[0], values[1]);
                    continue;
                }
                if (values.length == 1) {
                    throw new IllegalArgumentException("Line contains too few values: property=" + property + " location=" + location + " line=" + line + " values=" + Arrays.toString(values));
                }
                if (values.length <= 2) continue;
                throw new IllegalArgumentException("Line contains too many values: property=" + property + " location=" + location + " line=" + line + " values=" + Arrays.toString(values));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load time zone aliases: property=" + property + "  location=" + location, e);
        }
        return cache;
    }

    @NotNull
    public static ZoneId zoneId(@NotNull String timeZone) {
        return INSTANCE.zoneId(timeZone);
    }

    @NotNull
    public static String zoneName(@NotNull ZoneId timeZone) {
        return INSTANCE.zoneName(timeZone);
    }

    @NotNull
    public static Map<String, ZoneId> getAllZones() {
        return INSTANCE.getAllZones();
    }

    public static void addAlias(@NotNull String alias, @NotNull String zoneId) {
        INSTANCE.addAlias(alias, zoneId);
    }

    public static boolean rmAlias(@NotNull String alias) {
        return INSTANCE.rmAlias(alias);
    }

    private static class Cache {
        final Map<String, String> aliasMap = new HashMap<String, String>();
        final Map<String, String> reverseAliasMap = new HashMap<String, String>();
        final Map<String, ZoneId> allZones = new HashMap<String, ZoneId>();

        private Cache() {
            for (String tz : ZoneId.getAvailableZoneIds()) {
                this.allZones.put(tz, ZoneId.of(tz));
            }
        }

        public void addAlias(@NotNull String alias, @NotNull String zoneId) {
            ZoneId tz;
            Require.neqNull((Object)alias, (String)"alias");
            Require.neqNull((Object)zoneId, (String)"zoneId");
            if (this.allZones.containsKey(alias)) {
                throw new IllegalArgumentException("Time zone already exists with the alias name: alias=" + alias);
            }
            if (this.reverseAliasMap.containsKey(zoneId)) {
                throw new IllegalArgumentException("Alias for time zone is already present: time_zone=" + zoneId);
            }
            try {
                tz = ZoneId.of(zoneId);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Invalid time zone id: " + zoneId, ex);
            }
            this.aliasMap.put(alias, zoneId);
            this.reverseAliasMap.put(zoneId, alias);
            this.allZones.put(alias, tz);
        }

        public boolean rmAlias(@NotNull String alias) {
            Require.neqNull((Object)alias, (String)"alias");
            ZoneId zid = this.allZones.remove(alias);
            if (zid == null) {
                return false;
            }
            String zidStr = this.aliasMap.remove(alias);
            this.reverseAliasMap.remove(zidStr);
            return true;
        }

        @NotNull
        public ZoneId zoneId(@NotNull String timeZone) {
            Require.neqNull((Object)timeZone, (String)"timeZone");
            return ZoneId.of(timeZone, this.aliasMap);
        }

        @NotNull
        public String zoneName(@NotNull ZoneId timeZone) {
            Require.neqNull((Object)timeZone, (String)"timeZone");
            return this.reverseAliasMap.getOrDefault(timeZone.getId(), timeZone.getId());
        }

        @NotNull
        public Map<String, ZoneId> getAllZones() {
            return this.allZones;
        }
    }
}

